/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.program.view;

import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.program.domain.SetPayloadNode;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.valueobjects.Time;
import javax.inject.Inject;
import javax.swing.Icon;

public class SetPayloadNodeRenderer
implements ProgramTreeNodeRenderer {
    private final TextResource textResource;

    @Inject
    public SetPayloadNodeRenderer(TextResource textResource) {
        this.textResource = textResource;
    }

    public boolean isSupported(AbstractProgramNode programNode) {
        return programNode instanceof SetPayloadNode;
    }

    public Icon getIcon(AbstractProgramNode node, boolean isNodeDefined) {
        return null;
    }

    public String getText(AbstractProgramNode node, boolean isNodeDefined) {
        SetPayloadNode payloadNode = (SetPayloadNode)node;
        PayloadReferenceComponent payloadReference = payloadNode.getPayloadReferenceComponent();
        if (payloadReference != null && !payloadReference.isDefined()) {
            return this.textResource.setPayloadNode();
        }
        String payload = payloadNode.getPayloadDomain().asValue();
        Time transitionTime = payloadNode.getTransitionTime();
        String transitionInSeconds = String.valueOf(transitionTime.getIn(Time.Unit.SECONDS)) + "s";
        return String.format("%s: %s %s", this.textResource.setPayloadNode(), payload, transitionInSeconds);
    }
}

