/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.program.view;

import com.ur.lang.Defense;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.application.driver.payload.names.PayloadReferenceView;
import com.ur.polyscope.application.driver.payload.names.SetPayloadSelectionView;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.impl.common.domain.PayloadValidationRulesImpl;
import com.ur.polyscope.payload.impl.common.internal.InstallationPayloadRenderer;
import com.ur.polyscope.payload.impl.common.internal.PayloadComboBoxContentHandler;
import com.ur.polyscope.payload.impl.common.view.PayloadDetailsView;
import com.ur.polyscope.payload.impl.installation.domain.WarningPanel;
import com.ur.polyscope.payload.impl.program.domain.SendPayload;
import com.ur.polyscope.payload.impl.program.domain.SetPayloadNode;
import com.ur.polyscope.payload.impl.program.view.TransitionTimeView;
import com.ur.polyscope.payload.internal.resources.ImageResource;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.NumberField;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.PopupMenuListener;

public class SetPayloadView
extends CardPanel {
    private final ViewContext viewContext;
    private final PayloadService payloadService;
    private final PayloadDetailsView workpieceDetailsView;
    private final TransitionTimeView transitionTimeView;
    private final PayloadComboBoxContentHandler payloadComboBoxContentHandler;
    private final JButton setNowButton;
    private final WarningPanel warningPanel;
    private final SendPayload controllerSender;
    private final ActionListener comboBoxActionListener = new ComboBoxActionListener();
    private JComboBox payloadListComboBox;
    private SetPayloadNode node;

    @Inject
    public SetPayloadView(ViewContext viewContext, PayloadService payloadService, PayloadDetailsView workpieceDetailsView, PayloadValidationRulesImpl payloadValidationRules, RobotConfigurationProvider robotConfigurationProvider, SendPayload controllerSender, TransitionTimeView transitionTimeView) {
        this.viewContext = viewContext;
        this.payloadService = payloadService;
        this.workpieceDetailsView = workpieceDetailsView;
        this.transitionTimeView = transitionTimeView;
        this.payloadComboBoxContentHandler = new PayloadComboBoxContentHandler((com.ur.polyscope.payload.internal.resources.TextResource)viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class));
        this.warningPanel = new WarningPanel((TextResource)viewContext.getTextResource(TextResource.class), robotConfigurationProvider.getRobotPayload(), payloadValidationRules);
        this.controllerSender = controllerSender;
        workpieceDetailsView.setModifyListener(new DetailsViewModifiedListener());
        com.ur.polyscope.payload.internal.resources.TextResource translations = (com.ur.polyscope.payload.internal.resources.TextResource)viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class);
        this.setNowButton = new JButton(translations.setNow(), ImageResource.setactive());
        this.setNowButton.setName(PayloadReferenceView.SET_ACTIVE_PAYLOAD);
        this.setNowButton.setFocusable(false);
        this.setNowButton.addActionListener(e -> this.controllerSender.sendSetToolPayload(this.node));
        this.setLayout(new BorderLayout());
        this.add(viewContext.createFormBuilder().headerLabel(translations.setPayload(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end(2).label(translations.setTotalPayload(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component(this.createPayloadSelectionPanel(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component(workpieceDetailsView.asComponent(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_8_ROWS}).end(9).component((JComponent)this.warningPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel(), "Center");
        this.add(this.createTransitionTimeAndSetNowPanel(), "South");
        transitionTimeView.addTextUpdater(() -> this.node.textHasChanged());
    }

    private JPanel createTransitionTimeAndSetNowPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.createTransitionTimePanel(), "Center");
        result.add((Component)this.createSetNowPanel(), "South");
        return result;
    }

    private JComponent createPayloadSelectionPanel() {
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.payloadListComboBox = widgetFactory.createComboBox();
        this.payloadListComboBox.setName(SetPayloadSelectionView.COMBO_BOX_NAME);
        this.payloadListComboBox.setPreferredSize(new Dimension(80, 32));
        com.ur.polyscope.payload.internal.resources.TextResource textResource = (com.ur.polyscope.payload.internal.resources.TextResource)this.viewContext.getTextResource(com.ur.polyscope.payload.internal.resources.TextResource.class);
        InstallationPayloadRenderer payloadRenderer = new InstallationPayloadRenderer(this.payloadService, textResource);
        this.payloadListComboBox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)payloadRenderer));
        this.payloadListComboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer((RenderingStrategy)payloadRenderer, 500));
        this.payloadListComboBox.addActionListener(this.comboBoxActionListener);
        return this.payloadListComboBox;
    }

    private ComboBoxModel getPayloadModel(Set<DomainComponent> payloads) {
        return this.payloadComboBoxContentHandler.getPayloadComboBoxModel(payloads);
    }

    private Set<DomainComponent> getPayloadOptions() {
        LinkedHashSet<DomainComponent> allNamedPayloads = new LinkedHashSet<DomainComponent>();
        for (InstallationPayloadComponent c : this.payloadService.getAllPayloads()) {
            allNamedPayloads.add((DomainComponent)new PayloadReferenceComponent(c.getName(), this.payloadService));
        }
        allNamedPayloads.add((DomainComponent)(this.node.getPayloadDomain() instanceof PayloadReferenceComponent ? PayloadComponent.ZERO_PAYLOAD : this.node.getPayloadDomain()));
        return allNamedPayloads;
    }

    private JPanel createTransitionTimePanel() {
        JPanel transitionTimePanel = new JPanel();
        transitionTimePanel.setBorder(new MatteBorder(5, 0, 5, 0, UIManager.getColor("CardPanel.background")));
        transitionTimePanel.setLayout(new BoxLayout(transitionTimePanel, 2));
        transitionTimePanel.add(this.transitionTimeView);
        return transitionTimePanel;
    }

    private JPanel createSetNowPanel() {
        JPanel setNowPanel = new JPanel();
        setNowPanel.setAlignmentX(0.0f);
        setNowPanel.setLayout(new BoxLayout(setNowPanel, 0));
        setNowPanel.add(Box.createHorizontalGlue());
        setNowPanel.setBorder(new EmptyBorder(20, 15, 10, 15));
        setNowPanel.add(this.setNowButton);
        return setNowPanel;
    }

    private void performSetDomain(DomainComponent activePayloadComponent) {
        ComboBoxModel comboBoxModel = this.getPayloadModel(this.getPayloadOptions());
        comboBoxModel.setSelectedItem(activePayloadComponent);
        this.payloadListComboBox.setModel(comboBoxModel);
    }

    public void enter(Object o) {
        Defense.notNull((Object)o, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " entered with: null"));
        Defense.isInstanceOf((Object)o, SetPayloadNode.class, (String)("Invalid type, expected " + SetPayloadNode.class + ", but was " + o.getClass()));
        super.enter(o);
        this.node = (SetPayloadNode)((Object)o);
        this.payloadListComboBox.removeActionListener(this.comboBoxActionListener);
        this.payloadListComboBox.setModel(this.getPayloadModel(this.getPayloadOptions()));
        this.performSetDomain(this.node.getPayloadDomain());
        this.payloadListComboBox.addActionListener(this.comboBoxActionListener);
        if (this.node.getPayloadReferenceComponent() != null) {
            this.setPayloadReferenceComponent(this.node.getPayloadReferenceComponent());
        } else {
            this.setCustomPayloadComponent((PayloadComponent)this.node.getPayloadDomain());
        }
    }

    private void setPayloadReferenceComponent(PayloadReferenceComponent payloadReferenceComponent) {
        if (payloadReferenceComponent.isDefined()) {
            this.workpieceDetailsView.setDomain((DomainComponent)payloadReferenceComponent);
            this.transitionTimeView.setModel(this.node);
            InstallationPayloadComponent installationPayloadComponent = payloadReferenceComponent.dereference();
            this.updateWarning(installationPayloadComponent);
        } else {
            this.workpieceDetailsView.setDomain((DomainComponent)PayloadComponent.ZERO_PAYLOAD);
            this.transitionTimeView.setModel(this.node);
            this.warningPanel.setInvisible();
        }
        this.workpieceDetailsView.setReadOnly(true);
    }

    private void updateWarning(InstallationPayloadComponent payload) {
        this.warningPanel.updateWarningOrErrorMessage(payload.getMass(), payload.getCenterOfGravity(), payload.getInertiaMatrix());
    }

    private void setCustomPayloadComponent(PayloadComponent customPayloadComponent) {
        this.workpieceDetailsView.setDomain((DomainComponent)customPayloadComponent);
        this.workpieceDetailsView.setReadOnly(false);
        this.transitionTimeView.setModel(this.node);
        this.warningPanel.updateWarning(customPayloadComponent.getMass(), customPayloadComponent.getCenterOfGravity());
    }

    public NumberField payloadMassField() {
        return this.workpieceDetailsView.getPayloadMass();
    }

    public NumberField[] payloadCoGFields() {
        return this.workpieceDetailsView.getCoGFields();
    }

    public NumberField transitionTimeField() {
        return this.transitionTimeView.numberField();
    }

    public JButton setNowButton() {
        return this.setNowButton;
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.payloadSelectedInCombobox();
        }

        private void payloadSelectedInCombobox() {
            Object selectedItem = SetPayloadView.this.payloadListComboBox.getSelectedItem();
            if (selectedItem instanceof PayloadComponent) {
                SetPayloadView.this.node.setPayloadReferenceComponent(null);
                SetPayloadView.this.setCustomPayloadComponent((PayloadComponent)selectedItem);
            } else {
                PayloadReferenceComponent payloadReference = (PayloadReferenceComponent)selectedItem;
                if (payloadReference != null) {
                    SetPayloadView.this.node.setTransitionTime(SetPayloadView.this.transitionTimeView.getTransitionTime());
                    SetPayloadView.this.setPayloadReferenceComponent(payloadReference);
                }
                SetPayloadView.this.node.setPayloadReferenceComponent(payloadReference);
            }
        }
    }

    private class DetailsViewModifiedListener
    implements ViewComponent.ModifyListener {
        private DetailsViewModifiedListener() {
        }

        public void onModified(DomainComponent domainComponent) {
            if (domainComponent instanceof PayloadComponent) {
                SetPayloadView.this.node.setPayloadComponent((PayloadComponent)domainComponent);
                SetPayloadView.this.setCustomPayloadComponent((PayloadComponent)domainComponent);
            } else {
                Log.error((String)"Should not happen");
            }
        }
    }

    public static interface UpdateTransitionTimeText {
        public void updateText();
    }
}

