/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.program.view;

import com.ur.polyscope.payload.impl.common.internal.TransitionTimeInputFactory;
import com.ur.polyscope.payload.impl.program.domain.SetPayloadNode;
import com.ur.polyscope.payload.impl.program.view.SetPayloadView;
import com.ur.polyscope.payload.internal.resources.TextResource;
import com.ur.polyscope.valueobjects.Time;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.util.swing.HTML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransitionTimeView
extends JPanel {
    private NumberField transitionTimeField;
    private JLabel transitionHeaderLabel;
    private JLabel durationComponentLabel;
    private JLabel transitionTimeDescriptionLabel;
    private SetPayloadNode payloadNode = null;
    private SetPayloadView.UpdateTransitionTimeText textUpdater;

    @Inject
    public TransitionTimeView(ViewContext viewContext, TransitionTimeInputFactory transitionTimeInputFactory) {
        this.initComponents(viewContext, transitionTimeInputFactory);
    }

    private void initComponents(ViewContext viewContext, TransitionTimeInputFactory transitionTimeInputFactory) {
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.transitionTimeField = transitionTimeInputFactory.getEntryField(new TransitionTimeUpdater());
        this.transitionHeaderLabel = new JLabel(HTML.html((String)HTML.fontBold((String)textResource.transition())));
        this.durationComponentLabel = new JLabel(HTML.html((String)textResource.duration()));
        this.transitionTimeDescriptionLabel = new JLabel(HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)textResource.transitionTimeDescription()))));
        this.getContentComponent(viewContext.createFormBuilder());
    }

    private void getContentComponent(FormBuilder formBuilder) {
        formBuilder.component((JComponent)this.transitionHeaderLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.transitionTimeDescriptionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.durationComponentLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.transitionTimeField, new FormBuilder.PanelConstraints[0]).end().setOnPanel((JPanel)this);
    }

    public JComponent asComponent() {
        return this;
    }

    public void setModel(SetPayloadNode domainComponent) {
        this.payloadNode = domainComponent;
        this.transitionTimeField.setValue((Object)this.payloadNode.getTransitionTime());
    }

    public void addTextUpdater(SetPayloadView.UpdateTransitionTimeText updateTransitionTimeText) {
        this.textUpdater = updateTransitionTimeText;
    }

    public NumberField numberField() {
        return this.transitionTimeField;
    }

    public Time getTransitionTime() {
        return (Time)this.transitionTimeField.getValue();
    }

    private class TransitionTimeUpdater
    implements ActionListener {
        private TransitionTimeUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TransitionTimeView.this.payloadNode.setTransitionTime(TransitionTimeView.this.getTransitionTime());
            TransitionTimeView.this.textUpdater.updateText();
        }
    }
}

