/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.robotstate;

import com.google.inject.Inject;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.logging.Log;

public class ControllerSender {
    private ControllerInterface controllerInterface;

    @Inject
    public ControllerSender(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    public void sendSetToolPayload(DomainComponent payloadComponent) {
        ScriptWriter scriptWriter = new SetPayloadScript().generate(arg_0 -> ((DomainComponent)payloadComponent).writeScript(arg_0));
        if (!this.controllerInterface.runScript(scriptWriter.generateScript())) {
            Log.warning((String)"Can't set active payload. Controller command failed.");
        }
    }

    private static class SetPayloadScript {
        private ScriptWriter writer = new ScriptWriter();

        private SetPayloadScript() {
        }

        ScriptWriter generate(Writer function) {
            this.writer.defineSecondary("set_payload");
            function.write(this.writer);
            this.writer.end();
            return this.writer;
        }
    }

    static interface Writer {
        public void write(ScriptWriter var1);
    }
}

