/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.robotstate;

import com.ur.lang.StringUtils;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.payload.PayloadControllerRPC;
import com.ur.polyscope.payload.common.PayloadEstimationResult;
import com.ur.polyscope.payload.common.Wrench;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.vecmath.Vector3d;

public class HMC
implements PayloadControllerRPC {
    private static HMCInterface hmcInterface;

    @Inject
    public static void setHmcInterface(HMCInterface hmcInterface) {
        HMC.hmcInterface = hmcInterface;
    }

    private HMCResponse sendHMCMessageAndWait(String message) {
        return hmcInterface.sendHMCMessageAndWait(message);
    }

    private HMCResponse sendHMCMessageAndWait(StringBuffer s, int waitTime) {
        return hmcInterface.sendHMCMessageAndWait(s.toString(), waitTime);
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    static String toControllerBoolean(boolean b) {
        return b ? "True" : "False";
    }

    public Wrench getTCPForce(boolean payloadCompensation) {
        String message = "get_tcp_force(" + HMC.toControllerBoolean(payloadCompensation) + ")";
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(message);
        DataInputStream dis = this.createDataInputStream(hmcResponseMessage);
        if (dis == null) {
            return null;
        }
        try {
            double[] d = new double[6];
            int i = 0;
            while (i < d.length) {
                d[i] = dis.readDouble();
                ++i;
            }
            Vector3d forces = new Vector3d(d[0], d[1], d[2]);
            Vector3d torques = new Vector3d(d[3], d[4], d[5]);
            return new Wrench(forces, torques);
        }
        catch (IOException ex) {
            Log.warning((String)"Error reading forces and torques", (Throwable)ex);
            return null;
        }
    }

    private DataInputStream createDataInputStream(HMCResponse m) {
        if (m != null) {
            if (m.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(m.getResponseData());
            return new DataInputStream(bais);
        }
        Log.error((String)"HMC Response Message is null!?");
        return null;
    }

    private String createPose(Pose6d pose6d) {
        double[] d = pose6d.toArray();
        return "p[" + StringUtils.joinStringsWith((String)",", (double[])d) + "]";
    }

    private String createArray(Wrench wrench) {
        double[] d1 = new double[3];
        double[] d2 = new double[3];
        wrench.getForces().get(d1);
        wrench.getTorques().get(d2);
        return "[" + StringUtils.joinStringsWith((String)",", (double[])d1) + "," + StringUtils.joinStringsWith((String)",", (double[])d2) + "]";
    }

    public PayloadEstimationResult estimatePayload(Pose6d[] pose6ds, Wrench[] wrenches) {
        Object[] pose6dsString = new String[pose6ds.length];
        int i = 0;
        while (i < pose6dsString.length) {
            pose6dsString[i] = this.createPose(pose6ds[i]);
            ++i;
        }
        Object[] wrenchesString = new String[wrenches.length];
        int i2 = 0;
        while (i2 < wrenchesString.length) {
            wrenchesString[i2] = this.createArray(wrenches[i2]);
            ++i2;
        }
        StringBuffer s = new StringBuffer("estimate_payload(" + StringUtils.joinStringsWith((String)",", (Object[])pose6dsString) + "," + StringUtils.joinStringsWith((String)",", (Object[])wrenchesString) + ")");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s, 200);
        DataInputStream dis = this.createDataInputStream(hmcResponseMessage);
        if (dis == null) {
            return null;
        }
        try {
            boolean b = dis.readBoolean();
            double payload = HMC.round(dis.readDouble(), 2);
            double[] cog = new double[3];
            int i3 = 0;
            while (i3 < cog.length) {
                cog[i3] = HMC.round(dis.readDouble(), 5);
                ++i3;
            }
            return new PayloadEstimationResult(b, Weight.from((double)payload, (Weight.Unit)Weight.Unit.SI), new Vector3d(cog));
        }
        catch (IOException ex) {
            Log.warning((String)"Error reading forces and torques", (Throwable)ex);
            return null;
        }
    }
}

