/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.robotstate;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.payload.impl.robotstate.model.PayloadAttributesModel;
import com.ur.polyscope.payload.impl.robotstate.model.PayloadSource;
import com.ur.view.constants.comm.RobotStatePackageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class PayloadPackageConsumer
implements RobotStatePackageConsumer {
    private PayloadSource payloadSource;

    @Inject
    public PayloadPackageConsumer(PayloadSource payloadSource) {
        this.payloadSource = payloadSource;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        int messageOffset = 0;
        double mass = 0.0;
        double[] cog = new double[3];
        double[] inertia = new double[6];
        mass = stream.readDouble();
        messageOffset += 8;
        int i = 0;
        while (i < 3) {
            cog[i] = stream.readDouble();
            messageOffset += 8;
            ++i;
        }
        i = 0;
        while (i < 6) {
            inertia[i] = stream.readDouble();
            messageOffset += 8;
            ++i;
        }
        this.payloadSource.emit(new PayloadAttributesModel(mass, cog, inertia));
        return messageOffset;
    }

    public RobotStatePackageType getPackageType() {
        return RobotStatePackageType.ACTIVE_PAYLOAD;
    }

    public void initialize(RobotState robotState) {
    }
}

