/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.urcapapi;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.ur.polyscope.payload.PayloadSettings;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.payload.impl.urcapapi.PayloadImpl;
import com.ur.polyscope.payload.urcap.PayloadFactory;
import com.ur.polyscope.payload.urcap.PayloadInternal;
import com.ur.polyscope.payload.urcap.PayloadReferenceOwnerManager;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.urcaps.domain.value.InertiaMatrixFactory;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.value.PositionFactory;

@Singleton
public class PayloadFactoryImpl
implements PayloadFactory {
    static final String XML_ELEMENT_NAME = "Payload";
    static final String PAYLOAD_KEY = "key";
    static final String PAYLOAD_NAME = "name";
    private ReferenceHandlingStrategy<String, InstallationPayloadComponent, PayloadReferenceComponent> payloadReferenceHandlingStrategy;
    private PayloadSettings payloadSettings;
    private final PositionFactory positionFactory;
    private final InertiaMatrixFactory inertiaMatrixFactory;
    private PayloadReferenceOwnerManager payloadReferenceOwnerManager;
    private PayloadValidationRules payloadValidationRules;

    @Inject
    public PayloadFactoryImpl(PayloadSettings payloadSettings, PositionFactory positionFactory, InertiaMatrixFactory inertiaMatrixFactory, PayloadReferenceOwnerManager payloadReferenceOwnerManager, PayloadValidationRules payloadValidationRules) {
        this.payloadSettings = payloadSettings;
        this.payloadReferenceHandlingStrategy = payloadSettings.getPayloadReferenceHandlingStrategy();
        this.positionFactory = positionFactory;
        this.inertiaMatrixFactory = inertiaMatrixFactory;
        this.payloadReferenceOwnerManager = payloadReferenceOwnerManager;
        this.payloadValidationRules = payloadValidationRules;
    }

    public boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public String readKey(PersistReader reader) {
        return reader.getStringAttribute(PAYLOAD_KEY);
    }

    public Payload readValue(PersistReader reader) {
        String name = reader.getStringAttribute(PAYLOAD_NAME);
        return this.createPayloadWrapperByName(name);
    }

    private Payload createPayloadWrapperByName(String name) {
        PayloadReferenceComponent referenceTo = this.getReferenceToPayload(name);
        return this.createPayloadWrapperFromReference(referenceTo);
    }

    public Payload createPayloadWrapper(InstallationPayloadComponent installationPayloadComponent) {
        PayloadReferenceComponent referenceTo = (PayloadReferenceComponent)this.payloadReferenceHandlingStrategy.getReferenceTo((Object)installationPayloadComponent);
        return this.createPayloadWrapperFromReference(referenceTo);
    }

    private PayloadReferenceComponent getReferenceToPayload(String name) {
        InstallationPayloadComponent payloadByName = this.payloadSettings.getPayloadByName(name);
        PayloadReferenceComponent referenceTo = payloadByName != null ? (PayloadReferenceComponent)this.payloadReferenceHandlingStrategy.getReferenceTo((Object)payloadByName) : (PayloadReferenceComponent)this.payloadReferenceHandlingStrategy.getReference((Object)name);
        return referenceTo;
    }

    public Payload createPayloadWrapperFromReference(PayloadReferenceComponent referenceTo) {
        PayloadImpl payload = new PayloadImpl(referenceTo, this.positionFactory, this.inertiaMatrixFactory, this.payloadValidationRules);
        this.payloadReferenceOwnerManager.registerPayloadReferenceOwner((PayloadInternal)payload, referenceTo);
        return payload;
    }
}

