/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.urcapapi;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.SetPayloadNode;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.common.SphereOfWaterInertiaMatrixFactory;
import com.ur.polyscope.payload.urcap.PayloadInternal;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.CustomParametersPayloadNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.PayloadNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.SelectionPayloadNodeConfig;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class SetPayloadNodeConfigApplier {
    private final Provider<SphereOfWaterInertiaMatrixFactory> matrixFactoryProvider;
    private final PayloadService payloadService;

    @Inject
    public SetPayloadNodeConfigApplier(Provider<SphereOfWaterInertiaMatrixFactory> matrixFactoryProvider, PayloadService payloadService) {
        this.matrixFactoryProvider = matrixFactoryProvider;
        this.payloadService = payloadService;
    }

    public void apply(com.ur.polyscope.program.nodes.setpayload.SetPayloadNode realNode, PayloadNodeConfig config) {
        SetPayloadNode realPayloadNode = (SetPayloadNode)realNode;
        PayloadNodeConfig.ConfigType configType = config.getConfigType();
        if (configType == PayloadNodeConfig.ConfigType.CUSTOM_PARAMETERS) {
            this.applyCustomConfig(realPayloadNode, (CustomParametersPayloadNodeConfig)config);
        } else if (configType == PayloadNodeConfig.ConfigType.PAYLOAD_SELECTION) {
            this.applyPayloadSelection(realPayloadNode, (SelectionPayloadNodeConfig)config);
        }
    }

    private void applyPayloadSelection(SetPayloadNode realPayloadNode, SelectionPayloadNodeConfig config) {
        String key = ((PayloadInternal)config.getPayload()).getPayloadRef().getKey();
        realPayloadNode.setPayloadDomain((DomainComponent)new PayloadReferenceComponent(key, this.payloadService));
        realPayloadNode.setTransitionTime((Time)config.getTransitionTime());
    }

    private void applyCustomConfig(SetPayloadNode realPayloadNode, CustomParametersPayloadNodeConfig config) {
        Weight mass = (Weight)config.getMass();
        Vector3d centerOfGravity = SetPayloadNodeConfigApplier.asCenterOfGravity(config.getCenterOfGravity());
        Time transitionTime = (Time)config.getTransitionTime();
        Matrix3d inertiaMatrix = this.asInertiaMatrix(mass);
        realPayloadNode.setPayloadDomain((DomainComponent)new PayloadComponent(mass, centerOfGravity, inertiaMatrix));
        realPayloadNode.setTransitionTime(transitionTime);
    }

    private Matrix3d asInertiaMatrix(Weight mass) {
        SphereOfWaterInertiaMatrixFactory matrixFactory = (SphereOfWaterInertiaMatrixFactory)this.matrixFactoryProvider.get();
        return matrixFactory.getInertiaMatrix((Mass)mass);
    }

    private static Vector3d asCenterOfGravity(Position position) {
        double x = position.getX(Length.Unit.M);
        double y = position.getY(Length.Unit.M);
        double z = position.getZ(Length.Unit.M);
        return new Vector3d(x, y, z);
    }
}

