/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.urcapapi;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.SetPayloadNode;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadReferenceComponent;
import com.ur.polyscope.payload.urcap.PayloadFactory;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.CustomParametersPayloadNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.PayloadNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.PayloadNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.setpayloadnode.SelectionPayloadNodeConfig;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.PositionFactory;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Mass;
import javax.inject.Inject;
import javax.vecmath.Vector3d;

public class SetPayloadNodeConfigExtractor {
    private final PayloadNodeConfigFactory configFactory;
    private final PositionFactory positionFactory;
    private final PayloadFactory payloadFactory;

    @Inject
    public SetPayloadNodeConfigExtractor(PayloadNodeConfigFactory configFactory, PositionFactory positionFactory, PayloadFactory payloadFactory) {
        this.configFactory = configFactory;
        this.positionFactory = positionFactory;
        this.payloadFactory = payloadFactory;
    }

    public PayloadNodeConfig extract(com.ur.polyscope.program.nodes.setpayload.SetPayloadNode realNode) {
        SetPayloadNode payloadNode = (SetPayloadNode)realNode;
        DomainComponent payloadDomain = payloadNode.getPayloadDomain();
        if (payloadDomain instanceof PayloadComponent) {
            PayloadComponent custom = (PayloadComponent)payloadDomain;
            return this.extractCustomParametersPayloadNodeConfig(custom, payloadNode.getTransitionTime());
        }
        if (payloadDomain instanceof PayloadReferenceComponent) {
            PayloadReferenceComponent payloadReferenceComponent = (PayloadReferenceComponent)payloadDomain;
            return this.extractSelectionPayloadNodeConfig(payloadReferenceComponent, payloadNode.getTransitionTime());
        }
        return null;
    }

    private SelectionPayloadNodeConfig extractSelectionPayloadNodeConfig(PayloadReferenceComponent payloadReferenceComponent, Time transitionTime) {
        Payload payload = this.payloadFactory.createPayloadWrapperFromReference(payloadReferenceComponent);
        return this.configFactory.createSelectionConfig(payload, (com.ur.urcap.api.domain.value.simple.Time)transitionTime, ErrorHandler.AUTO_CORRECT);
    }

    private CustomParametersPayloadNodeConfig extractCustomParametersPayloadNodeConfig(PayloadComponent custom, Time transitionTime) {
        Weight mass = custom.getMass();
        Vector3d cog = custom.getCenterOfGravity();
        Position position = this.positionFactory.createPosition(cog.getX(), cog.getY(), cog.getZ(), Length.Unit.M);
        return this.configFactory.createCustomParametersConfig((Mass)mass, position, (com.ur.urcap.api.domain.value.simple.Time)transitionTime, ErrorHandler.AUTO_CORRECT);
    }
}

