/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.impl.urcapapi;

import com.ur.polyscope.valueobjects.validation.ValidationResult;
import com.ur.polyscope.valueobjects.validation.Validator;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Time;

public class TimeInSValidator {
    private static final int MAX_RECURSIVE_ERROR_HANDLER_CALLS = 100;
    private final Validator<Double> validator;
    private final SimpleValueFactory valueFactory;

    public TimeInSValidator(SimpleValueFactory svf, Validator<Double> validator) {
        this.validator = validator;
        this.valueFactory = svf;
    }

    public Time getValidValue(Time uncheckedValue, ErrorHandler<Time> errorHandler) {
        Time resultValue = uncheckedValue;
        ValidationResult validationResult = this.validator.validate((Object)this.asValidatorValue(uncheckedValue));
        if (validationResult.isValid()) {
            return resultValue;
        }
        resultValue = errorHandler != null ? this.handlerError(uncheckedValue, errorHandler) : this.asUnitValue((Double)validationResult.validValue());
        return resultValue;
    }

    private Time handlerError(Time value, ErrorHandler<Time> errorHandler) {
        boolean isValid = false;
        int triedTimes = 0;
        while (triedTimes < 100) {
            ValidationResult validationResult = this.validator.validate((Object)this.asValidatorValue(value));
            if (validationResult.isValid()) {
                isValid = true;
                break;
            }
            Time nearestValidValue = this.asUnitValue((Double)validationResult.validValue());
            value = (Time)errorHandler.onError((Object)value, (Object)nearestValidValue, validationResult.errorMessage());
            ++triedTimes;
        }
        if (!isValid) {
            throw new IllegalStateException("Too many recursive calls to error handler without valid value returned!");
        }
        return value;
    }

    protected Double asValidatorValue(Time value) {
        return value.getAs(Time.Unit.S);
    }

    protected Time asUnitValue(Double value) {
        return this.valueFactory.createTime(value.doubleValue(), Time.Unit.S);
    }
}

