/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.internal.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ImageResource.tryGetImage("rename.png");
            ImageResource.tryGetImage("form-warning.png");
            ImageResource.tryGetImage("info_icon.png");
            ImageResource.tryGetImage("default_icon.png");
            ImageResource.tryGetImage("gtk-cancel.png");
            ImageResource.tryGetImage("payload_estimation.png");
            ImageResource.tryGetImage("default_icon_selected.png");
            ImageResource.tryGetImage("blank.png");
            ImageResource.tryGetImage("gray_led.png");
            ImageResource.tryGetImage("setactive.png");
            ImageResource.tryGetImage("red_led.png");
            ImageResource.tryGetImage("toolAxisIllustrationSmall.png");
            ImageResource.tryGetImage("delete.png");
            ImageResource.tryGetImage("green_led.png");
            ImageResource.tryGetImage("metal-info.png");
            ImageResource.tryGetImage("wizard_icon.png");
            ImageResource.tryGetImage("gtk-add.png");
        }
    }

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="rename.png")
    public static @Key(value="rename.png") Icon rename() {
        return ImageResource.tryGetImage("rename.png");
    }

    @Key(value="form-warning.png")
    public static @Key(value="form-warning.png") Icon formWarning() {
        return ImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="info_icon.png")
    public static @Key(value="info_icon.png") Icon infoIcon() {
        return ImageResource.tryGetImage("info_icon.png");
    }

    @Key(value="default_icon.png")
    public static @Key(value="default_icon.png") Icon defaultIcon() {
        return ImageResource.tryGetImage("default_icon.png");
    }

    @Key(value="gtk-cancel.png")
    public static @Key(value="gtk-cancel.png") Icon gtkCancel() {
        return ImageResource.tryGetImage("gtk-cancel.png");
    }

    @Key(value="payload_estimation.png")
    public static @Key(value="payload_estimation.png") Icon payloadEstimation() {
        return ImageResource.tryGetImage("payload_estimation.png");
    }

    @Key(value="default_icon_selected.png")
    public static @Key(value="default_icon_selected.png") Icon defaultIconSelected() {
        return ImageResource.tryGetImage("default_icon_selected.png");
    }

    @Key(value="blank.png")
    public static @Key(value="blank.png") Icon blank() {
        return ImageResource.tryGetImage("blank.png");
    }

    @Key(value="gray_led.png")
    public static @Key(value="gray_led.png") Icon grayLed() {
        return ImageResource.tryGetImage("gray_led.png");
    }

    @Key(value="setactive.png")
    public static @Key(value="setactive.png") Icon setactive() {
        return ImageResource.tryGetImage("setactive.png");
    }

    @Key(value="red_led.png")
    public static @Key(value="red_led.png") Icon redLed() {
        return ImageResource.tryGetImage("red_led.png");
    }

    @Key(value="toolAxisIllustrationSmall.png")
    public static @Key(value="toolAxisIllustrationSmall.png") Icon toolAxisIllustrationSmall() {
        return ImageResource.tryGetImage("toolAxisIllustrationSmall.png");
    }

    @Key(value="delete.png")
    public static @Key(value="delete.png") Icon delete() {
        return ImageResource.tryGetImage("delete.png");
    }

    @Key(value="green_led.png")
    public static @Key(value="green_led.png") Icon greenLed() {
        return ImageResource.tryGetImage("green_led.png");
    }

    @Key(value="metal-info.png")
    public static @Key(value="metal-info.png") Icon metalInfo() {
        return ImageResource.tryGetImage("metal-info.png");
    }

    @Key(value="wizard_icon.png")
    public static @Key(value="wizard_icon.png") Icon wizardIcon() {
        return ImageResource.tryGetImage("wizard_icon.png");
    }

    @Key(value="gtk-add.png")
    public static @Key(value="gtk-add.png") Icon gtkAdd() {
        return ImageResource.tryGetImage("gtk-add.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

