/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.remotecontrol.impl;

import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ControlModeAccessControlListener
implements AccessControlStateListener {
    private final Subscription checksumChanged;
    private final EventManager eventManager;
    private final AccessModeService accessModeService;

    @Inject
    public ControlModeAccessControlListener(AccessModeService accessModeService, EventManager eventManager) {
        this.accessModeService = accessModeService;
        this.eventManager = eventManager;
        this.checksumChanged = eventManager.addStrongListener(ActiveSafetyChecksumListener.class, (Object)new ActiveSafetyChecksumListener(){

            public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent e) {
                ControlModeAccessControlListener.this.setupAccessControlListener();
                ControlModeAccessControlListener.this.checksumChanged.dispose();
            }
        });
    }

    public void accessControlStateChanged(UserAccessState oldState, UserAccessState currentState) {
        if (currentState.getOperationalModeSource() != OperationalModeSource.NONE) {
            this.accessModeService.setAccessMode(AccessMode.LOCAL);
        }
    }

    private void setupAccessControlListener() {
        this.eventManager.addStrongListener(AccessControlStateListener.class, (Object)this);
    }
}

