/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.remotecontrol.impl.ui;

import com.ur.polyscope.safety.remotecontrol.impl.ui.OperationalModeTooltip;
import com.ur.polyscope.safety.remotecontrol.impl.ui.SetupRemoteControlListener;
import com.ur.polyscope.safety.remotecontrol.impl.ui.SwitchToLocalControlAction;
import com.ur.polyscope.safety.remotecontrol.impl.ui.SwitchToRemoteControlAction;
import com.ur.polyscope.safety.remotecontrol.internal.RemoteControlImageResource;
import com.ur.polyscope.safety.remotecontrol.internal.TextResource;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.swing.SwingUtil;
import com.ur.swing.WidgetFactory;
import com.ur.util.event.EventManager;
import com.ur.util.swing.HTML;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class RemoteControlProfileButtonManager
implements SetupRemoteControlListener {
    private final TextResource textResource;
    private final AccessModeService accessModeService;
    private final UserAccessControl userAccessControl;
    private final OperationalModeTooltip tooltip;
    private final JMenuItem localControlItem;
    private final JMenuItem remoteControlItem;

    @Inject
    public RemoteControlProfileButtonManager(WidgetFactory widgetFactory, EventManager eventManager, TextResource textResource, SwitchToLocalControlAction switchToLocalControlAction, SwitchToRemoteControlAction switchToRemoteControlAction, AccessModeService accessModeService, UserAccessControl userAccessControl, OperationalModeTooltip tooltip) {
        this.textResource = textResource;
        this.accessModeService = accessModeService;
        this.userAccessControl = userAccessControl;
        this.tooltip = tooltip;
        this.localControlItem = widgetFactory.createMenuButton((Action)switchToLocalControlAction);
        this.remoteControlItem = widgetFactory.createMenuButton((Action)switchToRemoteControlAction);
        eventManager.addStrongListener(SetupRemoteControlListener.class, (Object)this);
    }

    public void populate(JPopupMenu popupMenu) {
        popupMenu.add(this.localControlItem);
        popupMenu.add(this.remoteControlItem);
    }

    public void update(JButton component, AccessMode accessMode) {
        if (AccessMode.isRemote((AccessMode)accessMode)) {
            component.setText(this.textResource.remoteControl());
            component.setIcon(RemoteControlImageResource.remoteControlLarge());
        } else {
            component.setText(this.textResource.localControl());
            component.setIcon(RemoteControlImageResource.localControlLarge());
        }
    }

    public void updateButtonsVisibility(AccessMode accessMode) {
        boolean isRemoteControlFeatureActivated = this.accessModeService.isRemoteControlFeatureEnabled();
        this.localControlItem.setVisible(AccessMode.isRemote((AccessMode)accessMode));
        this.remoteControlItem.setVisible(isRemoteControlFeatureActivated && AccessMode.isLocal((AccessMode)accessMode));
    }

    @Override
    public void remoteControlSetupChanged(boolean isFeatureEnabled) {
        if (!isFeatureEnabled) {
            return;
        }
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String displayMessage = RemoteControlProfileButtonManager.this.userAccessControl.getCurrentOperationalModeSource() == OperationalModeSource.NONE ? RemoteControlProfileButtonManager.this.textResource.remoteControlWithoutOperationalModesTooltip() : RemoteControlProfileButtonManager.this.textResource.remoteControlWithOperationalModesTooltip();
                RemoteControlProfileButtonManager.this.tooltip.showTooltip(HTML.html((String)displayMessage));
            }
        });
    }
}

