/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.remotecontrol.impl.ui;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.safety.remotecontrol.impl.ui.SetupRemoteControlListener;
import com.ur.polyscope.safety.remotecontrol.internal.RemoteControlImageResource;
import com.ur.polyscope.safety.remotecontrol.internal.TextResource;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.util.event.EventManager;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class SetupRemoteControlPanel
extends CardPanel
implements AdminLockListener {
    private static final String ENABLE = "enable.com.ur.polyscope.safety.remotecontrol.ui.SetupRemoteControlPanel";
    private static final String DISABLE = "disable.com.ur.polyscope.safety.remotecontrol.ui.SetupRemoteControlPanel";
    private static final Dimension BUTTON_PREFERRED_SIZE = new Dimension(220, 50);
    protected static final String SYSTEM_ADMIN_PASSWORD = "systemPassword";
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final EventManager eventManager;
    private final UserAccessControl userAccessControl;
    private final AccessModeService accessModeService;
    private final RequireAdminPasswordFooter passwordFooter;
    JButton enableButton;
    JButton disableButton;
    JLabel warningLabel;
    private boolean isLocked;

    @Inject
    public SetupRemoteControlPanel(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, EventManager eventManager, UserAccessControl userAccessControl, AccessModeService accessModeService) {
        this.passwordFooter = passwordFooter;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.eventManager = eventManager;
        this.userAccessControl = userAccessControl;
        this.accessModeService = accessModeService;
        this.initComponents();
        this.toggleWarningText();
        if (FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    public Object exit() {
        this.cleanup();
        return super.exit();
    }

    private void toggleWarningText() {
        if (this.userAccessControl.getCurrentOperationalModeSource() == OperationalModeSource.NONE) {
            this.warningLabel.setText(HTML.html((String)this.textResource.remoteControlWithoutOperationalModesWarning()));
        } else {
            this.warningLabel.setText(HTML.html((String)this.textResource.remoteControlWithOperationalModesWarning()));
        }
    }

    private void cleanup() {
        this.passwordFooter.resetPasswordField();
    }

    private void setRemoteControlEnabled(boolean enabled) {
        this.accessModeService.setRemoteControlFeatureEnabled(enabled);
        this.accessModeService.setAccessMode(AccessMode.LOCAL);
        this.eventManager.fireEvent(SetupRemoteControlListener.class, listener -> listener.remoteControlSetupChanged(enabled));
    }

    private void toggleButtons() {
        boolean isEnabled = this.accessModeService.isRemoteControlFeatureEnabled();
        this.disableButton.setEnabled(isEnabled && !this.isLocked);
        this.enableButton.setEnabled(!isEnabled && !this.isLocked);
    }

    public void enter(Object o) {
        this.removeAll();
        this.initComponents();
        this.toggleButtons();
        this.toggleWarningText();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIManager.getColor("CardPanel.background"));
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        JLabel descriptionLabel = widgetFactory.createLabel(HTML.html((String)this.textResource.remoteControlDescription()));
        descriptionLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Size.MEDIUM));
        this.warningLabel = widgetFactory.createLabel("");
        this.warningLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Style.ITALIC, URFontFactory.Size.SMALL));
        this.warningLabel.setIcon(RemoteControlImageResource.formWarning());
        JPanel warningPanel = new JPanel(new BorderLayout());
        warningPanel.setBorder(new LineBorder(UIManager.getColor("CardPanel.background")));
        warningPanel.add((Component)this.warningLabel, "Center");
        this.enableButton = widgetFactory.createButton((Action)((Object)new RemoteControlEnableAction()));
        this.enableButton.setPreferredSize(BUTTON_PREFERRED_SIZE);
        this.disableButton = widgetFactory.createButton((Action)((Object)new RemoteControlDisableAction()));
        this.disableButton.setPreferredSize(BUTTON_PREFERRED_SIZE);
        this.add(this.createCard(this.textResource.remoteControlAction(), this.viewContext.createFormBuilder().component((JComponent)descriptionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end(2).spacer().end().spacer().end().component((JComponent)warningPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end(2).spacer().end().spacer().end().spacer().component((JComponent)this.enableButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).component((JComponent)this.disableButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).end().getPanel()), "Center");
        this.addPasswordFooter();
    }

    private void addPasswordFooter() {
        JPanel footerPanel = this.passwordFooter.getFooterPanel();
        this.add(this.createCard(null, footerPanel), "South");
        if (!FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            footerPanel.setVisible(false);
        }
    }

    private JPanel createCard(String cardTitle, JComponent panel) {
        JPanel result = new JPanel(new BorderLayout());
        if (cardTitle != null) {
            result.setBorder((Border)new CardBorder(cardTitle));
        }
        result.add((Component)panel, "Center");
        return result;
    }

    public void doUnlock() {
        this.isLocked = false;
        this.toggleButtons();
    }

    public void doLock() {
        this.isLocked = true;
        this.enableButton.setEnabled(false);
        this.disableButton.setEnabled(false);
    }

    private class RemoteControlDisableAction
    extends AbstractActionDefinition {
        private RemoteControlDisableAction() {
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
            this.putValue("InternalName", SetupRemoteControlPanel.DISABLE);
            this.putValue("Name", SetupRemoteControlPanel.this.textResource.remoteControlDisable());
        }

        public void actionPerformed(ActionEvent e) {
            SetupRemoteControlPanel.this.setRemoteControlEnabled(false);
            SetupRemoteControlPanel.this.toggleButtons();
        }
    }

    private class RemoteControlEnableAction
    extends AbstractActionDefinition {
        private RemoteControlEnableAction() {
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
            this.putValue("InternalName", SetupRemoteControlPanel.ENABLE);
            this.putValue("Name", SetupRemoteControlPanel.this.textResource.remoteControlEnable());
        }

        public void actionPerformed(ActionEvent e) {
            SetupRemoteControlPanel.this.setRemoteControlEnabled(true);
            SetupRemoteControlPanel.this.toggleButtons();
        }
    }
}

