/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.remotecontrol.impl.ui;

import com.ur.polyscope.safety.remotecontrol.internal.RemoteControlImageResource;
import com.ur.polyscope.safety.remotecontrol.internal.TextResource;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.swing.ActionDefinition;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.view.constants.dev.OperationalMode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public class SwitchToRemoteControlAction
extends AbstractAction {
    public static final String SET_REMOTE_CONTROL = "setRemoteControl.HeaderMenu.SystemProfile";
    private final AccessModeService accessModeService;
    private final UserAccessControl userAccessControl;
    private final TextResource textResource;
    private final ErrorDialogCreator dialogCreator;

    @Inject
    public SwitchToRemoteControlAction(AccessModeService accessModeService, TextResource textResource, UserAccessControl userAccessControl, ErrorDialogCreator dialogCreator) {
        this.accessModeService = accessModeService;
        this.textResource = textResource;
        this.userAccessControl = userAccessControl;
        this.dialogCreator = dialogCreator;
        this.putValue("Name", textResource.remoteControlAction());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("InternalName", SET_REMOTE_CONTROL);
        this.putValue("SmallIcon", RemoteControlImageResource.remoteControlSmall());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isManual;
        boolean bl = isManual = this.userAccessControl.getCurrentOperationalModeSource() != OperationalModeSource.NONE && this.userAccessControl.getCurrentOperationalMode() == OperationalMode.MANUAL;
        if (isManual) {
            this.dialogCreator.showErrorDialog(new ErrorMessage(this.textResource.remoteControlAction(), this.textResource.remoteControlNotFromManual()), null);
        } else {
            this.accessModeService.setAccessMode(AccessMode.REMOTE);
        }
    }
}

