/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.internal.persistence;

import com.ur.lang.Defense;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.urcaps.domain.DataModelReader;
import com.ur.polyscope.urcaps.domain.DataModelWriter;
import com.ur.polyscope.urcaps.domain.Pair;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.AngularSpeed;
import com.ur.polyscope.valueobjects.Current;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Torque;
import com.ur.polyscope.valueobjects.Voltage;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.internal.persistence.AccelerationPersister;
import com.ur.polyscope.valueobjects.internal.persistence.AnglePersister;
import com.ur.polyscope.valueobjects.internal.persistence.AngularAccelerationPersister;
import com.ur.polyscope.valueobjects.internal.persistence.AngularSpeedPersister;
import com.ur.polyscope.valueobjects.internal.persistence.CurrentPersister;
import com.ur.polyscope.valueobjects.internal.persistence.ForcePersister;
import com.ur.polyscope.valueobjects.internal.persistence.LengthPersister;
import com.ur.polyscope.valueobjects.internal.persistence.MassPersister;
import com.ur.polyscope.valueobjects.internal.persistence.OptiMovePercentagePersister;
import com.ur.polyscope.valueobjects.internal.persistence.Persister;
import com.ur.polyscope.valueobjects.internal.persistence.PressurePersister;
import com.ur.polyscope.valueobjects.internal.persistence.SpeedPersister;
import com.ur.polyscope.valueobjects.internal.persistence.TimePersister;
import com.ur.polyscope.valueobjects.internal.persistence.TorquePersister;
import com.ur.polyscope.valueobjects.internal.persistence.VoltagePersister;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class VOtoDataModelAdapter
implements DataModelReader,
DataModelWriter {
    private static final String DATA_KEY = "key";
    private static final String DATA_VALUE = "value";
    private static final String DATA_UNIT = "unit";
    private final Map<String, Persister> voReaderMap = new HashMap<String, Persister>();
    private final Map<Class<? extends NumberValue>, Persister> voWriterMap = new HashMap<Class<? extends NumberValue>, Persister>();

    @Inject
    public VOtoDataModelAdapter() {
        this.addNewPersister(new AccelerationPersister(), Acceleration.class);
        this.addNewPersister(new AnglePersister(), Angle.class);
        this.addNewPersister(new AngularAccelerationPersister(), AngularAcceleration.class);
        this.addNewPersister(new AngularSpeedPersister(), AngularSpeed.class);
        this.addNewPersister(new CurrentPersister(), Current.class);
        this.addNewPersister(new ForcePersister(), Force.class);
        this.addNewPersister(new LengthPersister(), Length.class);
        this.addNewPersister(new PressurePersister(), Pressure.class);
        this.addNewPersister(new OptiMovePercentagePersister(), Percentage.class);
        this.addNewPersister(new SpeedPersister(), Speed.class);
        this.addNewPersister(new TimePersister(), Time.class);
        this.addNewPersister(new TorquePersister(), Torque.class);
        this.addNewPersister(new VoltagePersister(), Voltage.class);
        this.addNewPersister(new MassPersister(), Weight.class);
    }

    private void addNewPersister(Persister persister, Class<? extends NumberValue> type) {
        this.voReaderMap.put(persister.getElementName(), persister);
        this.voWriterMap.put(type, persister);
    }

    public boolean canRead(String nodeName) {
        Defense.notNullOrEmpty((String)nodeName);
        return this.voReaderMap.containsKey(nodeName);
    }

    public boolean canWrite(Object value) {
        return this.voWriterMap.containsKey(value.getClass());
    }

    public Pair<String, Object> readKeyValue(String nodeName, PersistReader reader) {
        String key = reader.getStringAttribute(DATA_KEY);
        String value = reader.getStringAttribute(DATA_VALUE);
        String unit = reader.getStringAttribute(DATA_UNIT);
        Object valueObject = this.voReaderMap.get(nodeName).readValue(value, unit);
        return new Pair((Object)key, valueObject);
    }

    public void writeKeyValue(Object value, String key, PersistWriter writer) {
        NumberValue numberValue = (NumberValue)value;
        Persister persister = this.voWriterMap.get(numberValue.getClass());
        writer.startNode(persister.getElementName());
        writer.addAttribute(DATA_KEY, key);
        writer.addAttribute(DATA_VALUE, numberValue.asDouble());
        writer.addAttribute(DATA_UNIT, persister.getSIUnitName());
        writer.endNode();
    }
}

