/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.internal.pose;

import com.ur.polyscope.valueobjects.internal.pose.PoseImpl;
import com.ur.polyscope.valueobjects.pose.PositionFactory;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.RotationFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PoseFactoryImpl
implements PoseFactory,
com.ur.urcap.api.domain.value.PositionFactory,
RotationFactory {
    private final PositionFactory positionFactory;

    @Inject
    public PoseFactoryImpl(PositionFactory positionFactory) {
        this.positionFactory = positionFactory;
    }

    public Position createPosition(double x, double y, double z, Length.Unit lengthUnit) {
        return this.positionFactory.createPosition(x, y, z, lengthUnit);
    }

    public Rotation createRotation(double rx, double ry, double rz, Angle.Unit angleUnit) {
        return this.positionFactory.createRotation(rx, ry, rz, angleUnit);
    }

    public Pose createPose(Position position, Rotation rotation) {
        return new PoseImpl(position, rotation);
    }

    public Pose createPose(double x, double y, double z, double rx, double ry, double rz, Length.Unit lengthUnit, Angle.Unit angleUnit) {
        Position position = this.positionFactory.createPosition(x, y, z, lengthUnit);
        Rotation rotation = this.positionFactory.createRotation(rx, ry, rz, angleUnit);
        return new PoseImpl(position, rotation);
    }
}

