/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.internal.pose;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PoseImpl
implements Pose,
XmlSerializable {
    private final Position position;
    private final Rotation rotation;
    private Pose6d poseAsPose6d;
    static final String XML_ELEMENT_NAME = "Pose";
    static final String POSE_KEY = "key";
    private static final String POSE_POSITION_KEY = "posePosition";
    private static final String POSE_ROTATION_KEY = "poseRotation";

    PoseImpl(Position position, Rotation rotation) {
        this.position = position;
        this.rotation = rotation;
    }

    public Position getPosition() {
        return this.position;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public double[] toArray() {
        return new double[]{this.position.getX(), this.position.getY(), this.position.getZ(), this.rotation.getRX(), this.rotation.getRY(), this.rotation.getRZ()};
    }

    public double[] toArray(Length.Unit lengthUnit, Angle.Unit angleUnit) {
        return new double[]{this.position.getX(lengthUnit), this.position.getY(lengthUnit), this.position.getZ(lengthUnit), this.rotation.getRX(angleUnit), this.rotation.getRY(angleUnit), this.rotation.getRZ(angleUnit)};
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose other = (Pose)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.position, (Object)other.getPosition());
        equalsBuilder.append((Object)this.rotation, (Object)other.getRotation());
        return equalsBuilder.isEquals();
    }

    public boolean epsilonEquals(Pose other, double epsilon) {
        return this.getPoseAsPose6d().epsilonEquals(this.createPose6d(other.getPosition(), other.getRotation()), epsilon);
    }

    public boolean epsilonEquals(Pose other, double positionEpsilon, Length.Unit lengthUnit, double rotationEpsilon, Angle.Unit angleUnit) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getPosition().epsilonEquals(other.getPosition(), positionEpsilon, lengthUnit)) {
            return false;
        }
        return this.getRotation().epsilonEquals(other.getRotation(), rotationEpsilon, angleUnit);
    }

    private Pose6d getPoseAsPose6d() {
        if (this.poseAsPose6d == null) {
            this.poseAsPose6d = this.createPose6d(this.getPosition(), this.getRotation());
        }
        return this.poseAsPose6d;
    }

    private Pose6d createPose6d(Position pos, Rotation rot) {
        Vector3d p = new Vector3d(pos.getX(Length.Unit.M), pos.getY(Length.Unit.M), pos.getZ(Length.Unit.M));
        Vector3d r = new Vector3d(rot.getRX(Angle.Unit.RAD), rot.getRY(Angle.Unit.RAD), rot.getRZ(Angle.Unit.RAD));
        return new Pose6d((Tuple3d)p, (Tuple3d)r);
    }

    public String toString() {
        return "p[" + this.position.getX(Length.Unit.M) + "," + this.position.getY(Length.Unit.M) + "," + this.position.getZ(Length.Unit.M) + "," + this.rotation.getRX(Angle.Unit.RAD) + "," + this.rotation.getRY(Angle.Unit.RAD) + "," + this.rotation.getRZ(Angle.Unit.RAD) + "]";
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.position).append((Object)this.rotation).toHashCode();
    }

    public void write(PersistWriter writer, String key) {
        writer.startNode(XML_ELEMENT_NAME);
        writer.addAttribute(POSE_KEY, key);
        ((XmlSerializable)this.getPosition()).write(writer, POSE_POSITION_KEY);
        ((XmlSerializable)this.getRotation()).write(writer, POSE_ROTATION_KEY);
        writer.endNode();
    }
}

