/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.internal.pose;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.urcaps.domain.value.LengthImpl;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Objects;
import javax.vecmath.Vector3d;

public class PositionImpl
implements Position,
XmlSerializable {
    private final Vector3d vector3d;
    private final Length x;
    private final Length y;
    private final Length z;
    private static final String XML_ELEMENT_NAME = "Position";
    private static final String POSITION_KEY = "key";
    private static final String POSITION_X = "X";
    private static final String POSITION_Y = "Y";
    private static final String POSITION_Z = "Z";

    PositionImpl(double x, double y, double z, Length.Unit unit) {
        this((Length)new LengthImpl(x, unit), (Length)new LengthImpl(y, unit), (Length)new LengthImpl(z, unit));
    }

    private PositionImpl(Length x, Length y, Length z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vector3d = new Vector3d(this.getX(Length.Unit.M), this.getY(Length.Unit.M), this.getZ(Length.Unit.M));
    }

    @Deprecated
    public double getX() {
        return this.vector3d.getX();
    }

    @Deprecated
    public double getY() {
        return this.vector3d.getY();
    }

    @Deprecated
    public double getZ() {
        return this.vector3d.getZ();
    }

    public double getX(Length.Unit unit) {
        return this.x.getAs(unit);
    }

    public double getY(Length.Unit unit) {
        return this.y.getAs(unit);
    }

    public double getZ(Length.Unit unit) {
        return this.z.getAs(unit);
    }

    public boolean epsilonEquals(Position other, double epsilon, Length.Unit unit) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (Math.abs(this.getX(unit) - other.getX(unit)) > epsilon) {
            return false;
        }
        if (Math.abs(this.getY(unit) - other.getY(unit)) > epsilon) {
            return false;
        }
        return !(Math.abs(this.getZ(unit) - other.getZ(unit)) > epsilon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionImpl position = (PositionImpl)o;
        if (!Objects.equals(this.x, position.x)) {
            return false;
        }
        if (!Objects.equals(this.y, position.y)) {
            return false;
        }
        return Objects.equals(this.z, position.z);
    }

    public int hashCode() {
        int result = this.x != null ? this.x.hashCode() : 0;
        result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
        result = 31 * result + (this.z != null ? this.z.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Position{");
        sb.append("x=").append(this.x);
        sb.append(", y=").append(this.y);
        sb.append(", z=").append(this.z);
        sb.append('}');
        return sb.toString();
    }

    public void write(PersistWriter writer, String key) {
        writer.startNode(XML_ELEMENT_NAME);
        writer.addAttribute(POSITION_KEY, key);
        ((XmlSerializable)this.x).write(writer, POSITION_X);
        ((XmlSerializable)this.y).write(writer, POSITION_Y);
        ((XmlSerializable)this.z).write(writer, POSITION_Z);
        writer.endNode();
    }

    public static boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public static String readKey(PersistReader reader) {
        return reader.getStringAttribute(POSITION_KEY);
    }

    public static PositionImpl readValue(PersistReader reader) {
        Length[] xyz = new Length[3];
        for (int i = 0; i < 3; ++i) {
            reader.moveToChildNode();
            xyz[i] = LengthImpl.readValue((PersistReader)reader);
            reader.moveToParentNode();
        }
        return new PositionImpl(xyz[0], xyz[1], xyz[2]);
    }
}

