/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.valueobjects.internal.pose;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.XmlSerializable;
import com.ur.polyscope.urcaps.domain.value.AngleImpl;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.simple.Angle;
import java.util.Objects;
import javax.vecmath.Vector3d;

public class RotationImpl
implements Rotation,
XmlSerializable {
    private static final String XML_ELEMENT = "Rotation";
    private static final String ROTATION_KEY = "key";
    private static final String ROTATION_X = "RX";
    private static final String ROTATION_Y = "RY";
    private static final String ROTATION_Z = "RZ";
    private final Vector3d vector3d;
    private final Angle rx;
    private final Angle ry;
    private final Angle rz;

    public RotationImpl(double rotationX, double rotationY, double rotationZ, Angle.Unit unit) {
        this((Angle)new AngleImpl(rotationX, unit), (Angle)new AngleImpl(rotationY, unit), (Angle)new AngleImpl(rotationZ, unit));
    }

    private RotationImpl(Angle rx, Angle ry, Angle rz) {
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.vector3d = new Vector3d(this.getRX(Angle.Unit.RAD), this.getRY(Angle.Unit.RAD), this.getRZ(Angle.Unit.RAD));
    }

    @Deprecated
    public double getRX() {
        return this.vector3d.getX();
    }

    @Deprecated
    public double getRY() {
        return this.vector3d.getY();
    }

    @Deprecated
    public double getRZ() {
        return this.vector3d.getZ();
    }

    public double getRX(Angle.Unit unit) {
        return this.rx.getAs(unit);
    }

    public double getRY(Angle.Unit unit) {
        return this.ry.getAs(unit);
    }

    public double getRZ(Angle.Unit unit) {
        return this.rz.getAs(unit);
    }

    public boolean epsilonEquals(Rotation other, double epsilon, Angle.Unit unit) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (Math.abs(this.getRX(unit) - other.getRX(unit)) > epsilon) {
            return false;
        }
        if (Math.abs(this.getRY(unit) - other.getRY(unit)) > epsilon) {
            return false;
        }
        return !(Math.abs(this.getRZ(unit) - other.getRZ(unit)) > epsilon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RotationImpl rotation = (RotationImpl)o;
        if (!Objects.equals(this.rx, rotation.rx)) {
            return false;
        }
        if (!Objects.equals(this.ry, rotation.ry)) {
            return false;
        }
        return Objects.equals(this.rz, rotation.rz);
    }

    public int hashCode() {
        int result = this.rx != null ? this.rx.hashCode() : 0;
        result = 31 * result + (this.ry != null ? this.ry.hashCode() : 0);
        result = 31 * result + (this.rz != null ? this.rz.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rotation{");
        sb.append("rx=").append(this.rx);
        sb.append(", ry=").append(this.ry);
        sb.append(", rz=").append(this.rz);
        sb.append('}');
        return sb.toString();
    }

    public void write(PersistWriter writer, String key) {
        writer.startNode(XML_ELEMENT);
        writer.addAttribute(ROTATION_KEY, key);
        ((XmlSerializable)this.rx).write(writer, ROTATION_X);
        ((XmlSerializable)this.ry).write(writer, ROTATION_Y);
        ((XmlSerializable)this.rz).write(writer, ROTATION_Z);
        writer.endNode();
    }

    public static boolean canRead(String nodeName) {
        return XML_ELEMENT.equals(nodeName);
    }

    public static String readKey(PersistReader reader) {
        return reader.getStringAttribute(ROTATION_KEY);
    }

    public static RotationImpl readValue(PersistReader reader) {
        Angle[] xyz = new Angle[3];
        for (int i = 0; i < 3; ++i) {
            reader.moveToChildNode();
            xyz[i] = AngleImpl.readValue((PersistReader)reader);
            reader.moveToParentNode();
        }
        return new RotationImpl(xyz[0], xyz[1], xyz[2]);
    }
}

