/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.geomfeature.urcaps.domain.feature;

import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.urcaps.domain.ValueParser;
import com.ur.urcap.api.domain.feature.Feature;
import javax.inject.Inject;

public class FeatureValueParser
implements ValueParser<Feature> {
    private FeatureService featureService;
    private final FeatureWrapService featureWrapService;
    static final String XML_ELEMENT_NAME = "Feature";
    static final String FEATURE_KEY = "key";
    static final String FEATURE_NAME = "name";

    @Inject
    public FeatureValueParser(FeatureService featureService, FeatureWrapService featureWrapService) {
        this.featureService = featureService;
        this.featureWrapService = featureWrapService;
    }

    public boolean canRead(String nodeName) {
        return XML_ELEMENT_NAME.equals(nodeName);
    }

    public String readKey(PersistReader reader) {
        return reader.getStringAttribute(FEATURE_KEY);
    }

    public Feature readValue(PersistReader reader) {
        String name = reader.getStringAttribute(FEATURE_NAME);
        SpatialFeatureReference featureReference = this.featureService.getFeatureByName(name);
        return featureReference != null ? this.featureWrapService.wrapFeature(featureReference) : null;
    }
}

