/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.geomfeature.urcaps.domain.feature;

import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.geomfeature.FeatureInternal;
import com.ur.polyscope.geomfeature.LineSpatialFeature;
import com.ur.polyscope.geomfeature.PlaneSpatialFeature;
import com.ur.polyscope.geomfeature.PoseSpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.ToolSpatialFeature;
import com.ur.polyscope.geomfeature.owner.FeatureReferenceOwnerManager;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.BaseFeatureImpl;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.FeatureImpl;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.FeatureLineImpl;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.FeaturePlaneImpl;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.FeaturePointImpl;
import com.ur.polyscope.geomfeature.urcaps.domain.feature.ToolFeatureImpl;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.value.PoseFactory;
import javax.inject.Inject;

public class FeatureWrapServiceImpl
implements FeatureWrapService {
    private final PoseFactory poseFactory;
    private final FeatureReferenceOwnerManager featureReferenceOwnerManager;

    @Inject
    public FeatureWrapServiceImpl(PoseFactory poseFactory, FeatureReferenceOwnerManager featureReferenceOwnerManager) {
        this.poseFactory = poseFactory;
        this.featureReferenceOwnerManager = featureReferenceOwnerManager;
    }

    public SpatialFeature unwrapFeature(Feature feature) {
        return ((FeatureImpl)feature).getFeature();
    }

    public Feature wrapFeature(SpatialFeature spatialFeature) {
        FeatureImpl result = null;
        if (spatialFeature != null) {
            if (spatialFeature instanceof PoseSpatialFeature) {
                result = new FeaturePointImpl((PoseSpatialFeature)spatialFeature, this.poseFactory);
            } else if (spatialFeature instanceof LineSpatialFeature) {
                result = new FeatureLineImpl((LineSpatialFeature)spatialFeature, this.poseFactory);
            } else if (spatialFeature instanceof PlaneSpatialFeature) {
                result = new FeaturePlaneImpl((PlaneSpatialFeature)spatialFeature, this.poseFactory);
            } else if (spatialFeature instanceof BaseSpatialFeature) {
                result = new BaseFeatureImpl(spatialFeature, this.poseFactory);
            } else if (spatialFeature instanceof ToolSpatialFeature) {
                result = new ToolFeatureImpl(spatialFeature, this.poseFactory);
            } else {
                throw new IllegalArgumentException("Unsupported Feature implementation:" + spatialFeature);
            }
        }
        return result;
    }

    public Feature wrapFeature(SpatialFeatureReference ref) {
        FeatureImpl result = null;
        SpatialFeature spatialFeature = ref.dereferenceInUnderwayInstallation();
        if (spatialFeature != null) {
            if (spatialFeature instanceof PoseSpatialFeature) {
                result = new FeaturePointImpl((SpatialFeatureReference<PoseSpatialFeature>)ref, this.poseFactory);
            } else if (spatialFeature instanceof LineSpatialFeature) {
                result = new FeatureLineImpl((SpatialFeatureReference<LineSpatialFeature>)ref, this.poseFactory);
            } else if (spatialFeature instanceof PlaneSpatialFeature) {
                result = new FeaturePlaneImpl((SpatialFeatureReference<PlaneSpatialFeature>)ref, this.poseFactory);
            } else if (spatialFeature instanceof BaseSpatialFeature) {
                result = new BaseFeatureImpl((SpatialFeatureReference<SpatialFeature>)ref, this.poseFactory);
            } else if (spatialFeature instanceof ToolSpatialFeature) {
                result = new ToolFeatureImpl((SpatialFeatureReference<SpatialFeature>)ref, this.poseFactory);
            } else {
                throw new IllegalArgumentException("Unsupported Feature implementation:" + spatialFeature);
            }
            if (result instanceof FeatureInternal) {
                this.featureReferenceOwnerManager.registerReferenceOwner((FeatureInternal)result, ref);
            }
        }
        return result;
    }
}

