/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.api.aspects;

import com.ur.swing.JemmyUtils;
import java.awt.Component;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.util.NameComponentChooser;

@Aspect
public class ScreenShotTakerAspect {
    private int photoNumber = 0;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ScreenShotTakerAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(* com.ur.polyscope.driver.api.BaseDriver+.*(..))")
    private /* synthetic */ void takeScreenShotOfAllDrivers() {
    }

    @Pointcut(value="@annotation(com.ur.polyscope.driver.api.aspects.SuppressScreenShot)")
    public /* synthetic */ void hasSuppressAnnotation() {
    }

    @Pointcut(value="execution(* *.is*(..))")
    public /* synthetic */ void isQueryMethod() {
    }

    @Pointcut(value="takeScreenShotOfAllDrivers() && !hasSuppressAnnotation() && !isQueryMethod()")
    public /* synthetic */ void takeScreenShotOfDriver() {
    }

    @Before(value="takeScreenShotOfDriver()")
    public void screenShotBeforeMethodExecution(JoinPoint joinPoint) {
        if (JemmyUtils.doTakeScreenShots()) {
            String fileName = this.createFileName(joinPoint);
            this.takeScreenShot(fileName);
        }
    }

    @After(value="takeScreenShotOfDriver()")
    public void screenShotAfterMethodExecution(JoinPoint joinPoint) {
        if (JemmyUtils.doTakeScreenShots()) {
            String fileName = this.createFileName(joinPoint);
            this.takeScreenShot(fileName);
        }
    }

    private String createFileName(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] splitClassName = methodSignature.getDeclaringTypeName().split("\\.");
        String className = splitClassName.length > 1 ? splitClassName[splitClassName.length - 1] : methodSignature.getDeclaringTypeName();
        String methodName = methodSignature.getName();
        ++this.photoNumber;
        return String.valueOf(this.photoNumber) + "_" + className + "_" + methodName;
    }

    private void takeScreenShot(String fileName) {
        Component frame = new JFrameOperator((ComponentChooser)new NameComponentChooser("urgui.URGUI")).getSource();
        JemmyUtils.takePhoto((Component)frame, (String)fileName);
    }

    public static ScreenShotTakerAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.ur.polyscope.driver.api.aspects.ScreenShotTakerAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ScreenShotTakerAspect.ajc$perSingletonInstance = new ScreenShotTakerAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

