/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.api.dialog;

import com.ur.polyscope.driver.api.dialog.Dialog;
import com.ur.polyscope.driver.api.dialog.DialogDriver;
import com.ur.polyscope.driver.api.timeout.WaitDialogTimeout;
import com.ur.swing.ComponentDriver;
import java.util.concurrent.TimeUnit;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.DialogOperator;
import org.netbeans.jemmy.operators.JDialogOperator;

public abstract class DialogDriverFactory {
    private DialogDriverFactory() {
    }

    public static DialogDriver createDriver(Dialog dialog) {
        JDialogOperator operator = DialogDriverFactory.dialogFromName(dialog.getName());
        return new DialogDriver(operator);
    }

    public static boolean isDialogShown(Dialog dialog) {
        try {
            DialogDriverFactory.dialogFromName(dialog.getName());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDialogShown(Dialog dialog, int timeAmount, TimeUnit timeUnit) {
        WaitDialogTimeout waitDialogTimeout = new WaitDialogTimeout();
        waitDialogTimeout.setCurrentWaitTimeout(timeUnit.toMillis(timeAmount));
        boolean result = DialogDriverFactory.isDialogShown(dialog);
        waitDialogTimeout.resetTimeOut();
        return result;
    }

    private static JDialogOperator dialogFromName(String name) {
        return new JDialogOperator((ComponentChooser)new ComponentDriver.MultiComponentChooser((ComponentChooser)new DialogOperator.DialogFinder(), new ComponentChooser[]{ComponentDriver.withName((String)name), ComponentDriver.showing()}));
    }
}

