/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.driver.api.dialog;

import com.ur.lang.EqualsUtil;
import com.ur.util.Waiting;
import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;

public class ModalDialogDriver {
    protected final JDialogOperator dialogOperator;
    protected final JDialog dialog;

    public ModalDialogDriver(JDialog dialog) {
        this.dialog = dialog;
        this.dialogOperator = new JDialogOperator(dialog);
    }

    public static ModalDialogDriver waitModalDialogWithTitle(final String title) {
        ComponentChooser chooser = new ComponentChooser(){

            public String getDescription() {
                return "with title '" + title + "'";
            }

            public boolean checkComponent(Component comp) {
                if (comp == null) {
                    return false;
                }
                if (!(comp instanceof JDialog)) {
                    return false;
                }
                JDialog dialog = (JDialog)comp;
                if (!dialog.isModal()) {
                    return false;
                }
                if (title == null) {
                    return true;
                }
                return EqualsUtil.equals((Object)dialog.getTitle(), (Object)title);
            }
        };
        JDialog dialog = JDialogOperator.waitJDialog((ComponentChooser)chooser);
        if (dialog == null) {
            return null;
        }
        return new ModalDialogDriver(dialog);
    }

    public static ModalDialogDriver waitModalDialog() {
        return ModalDialogDriver.waitModalDialogWithTitle(null);
    }

    public static void waitForTaskProgressCompletion(final String taskTitle) {
        JDialogOperator.JDialogFinder chooser = new JDialogOperator.JDialogFinder(){

            public String getDescription() {
                return String.valueOf(super.getDescription()) + " with title '" + taskTitle + "'";
            }

            public boolean checkComponent(Component comp) {
                if (super.checkComponent(comp)) {
                    JDialog dialog = (JDialog)comp;
                    if (!dialog.isModal()) {
                        return false;
                    }
                    return JLabelOperator.findJLabel((Container)dialog, (String)taskTitle, (boolean)false, (boolean)true) != null;
                }
                return false;
            }
        };
        JDialog dialog = JDialogOperator.waitJDialog((ComponentChooser)chooser);
        ModalDialogDriver modalDialogDriver = new ModalDialogDriver(dialog);
        modalDialogDriver.waitForClose();
    }

    public <T> T getSubComponent(final Class<T> type, final String name, final int index) {
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if (component == null) {
                    return false;
                }
                if (!type.isInstance(component)) {
                    return false;
                }
                if (!component.isShowing()) {
                    return false;
                }
                if (name == null) {
                    return true;
                }
                return name.equals(component.getName());
            }

            public String getDescription() {
                return String.valueOf(type.getName()) + " with name " + name + " at " + index;
            }
        };
        this.dialogOperator.findSubComponent(chooser);
        return (T)this.dialogOperator.findSubComponent(chooser, index);
    }

    public void pushButton(int index) {
        JButton button = this.getSubComponent(JButton.class, null, index);
        JButtonOperator operator = new JButtonOperator(button);
        operator.clickMouse();
    }

    public void pushButton(String name) {
        JButton button = this.getSubComponent(JButton.class, name, 0);
        JButtonOperator operator = new JButtonOperator(button);
        operator.clickMouse();
    }

    public void waitForClose() {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !ModalDialogDriver.this.dialog.isShowing();
            }
        }, (int)5000, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

