/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip;

import java.util.HashMap;
import java.util.Map;

public enum RTInputData {
    speed_slider_mask(0),
    speed_slider_fraction(1),
    standard_digital_output_mask(2),
    configurable_digital_output_mask(3),
    tool_digital_output_mask(4),
    standard_digital_output(5),
    configurable_digital_output(6),
    tool_digital_output(7),
    standard_analog_output_mask(8),
    standard_analog_output_type(9),
    standard_analog_output_0(10),
    standard_analog_output_1(11),
    input_bit_registers0_to_31(12),
    input_bit_registers32_to_63(13),
    input_int_register_0(14),
    input_int_register_1(15),
    input_int_register_2(16),
    input_int_register_3(17),
    input_int_register_4(18),
    input_int_register_5(19),
    input_int_register_6(20),
    input_int_register_7(21),
    input_int_register_8(22),
    input_int_register_9(23),
    input_int_register_10(24),
    input_int_register_11(25),
    input_int_register_12(26),
    input_int_register_13(27),
    input_int_register_14(28),
    input_int_register_15(29),
    input_int_register_16(30),
    input_int_register_17(31),
    input_int_register_18(32),
    input_int_register_19(33),
    input_int_register_20(34),
    input_int_register_21(35),
    input_int_register_22(36),
    input_int_register_23(37),
    input_double_register_0(38),
    input_double_register_1(39),
    input_double_register_2(40),
    input_double_register_3(41),
    input_double_register_4(42),
    input_double_register_5(43),
    input_double_register_6(44),
    input_double_register_7(45),
    input_double_register_8(46),
    input_double_register_9(47),
    input_double_register_10(48),
    input_double_register_11(49),
    input_double_register_12(50),
    input_double_register_13(51),
    input_double_register_14(52),
    input_double_register_15(53),
    input_double_register_16(54),
    input_double_register_17(55),
    input_double_register_18(56),
    input_double_register_19(57),
    input_double_register_20(58),
    input_double_register_21(59),
    input_double_register_22(60),
    input_double_register_23(61),
    external_force_torque(62);

    private static final Map<Integer, RTInputData> idCache;
    private int id;

    static {
        idCache = new HashMap<Integer, RTInputData>();
    }

    private RTInputData(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RTInputData byId(int id) {
        if (idCache.isEmpty()) {
            RTInputData.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ErrorCode with id " + id + " supported!");
        return RTInputData.values()[0];
    }

    private static void buildCache() {
        RTInputData[] rTInputDataArray = RTInputData.values();
        int n = rTInputDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RTInputData each = rTInputDataArray[n2];
            idCache.put(each.getId(), each);
            ++n2;
        }
    }
}

