/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip;

import java.util.HashMap;
import java.util.Map;

public enum WatchdogAction {
    IGNORE(0),
    PAUSE(1),
    STOP(2);

    private static final Map<Integer, WatchdogAction> idCache;
    private int id;

    static {
        idCache = new HashMap<Integer, WatchdogAction>();
    }

    private WatchdogAction(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static WatchdogAction byId(int id) {
        if (idCache.isEmpty()) {
            WatchdogAction.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ErrorCode with id " + id + " supported!");
        return WatchdogAction.values()[0];
    }

    private static void buildCache() {
        WatchdogAction[] watchdogActionArray = WatchdogAction.values();
        int n = watchdogActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WatchdogAction each = watchdogActionArray[n2];
            idCache.put(each.getId(), each);
            ++n2;
        }
    }
}

