/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.generated;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ImageResource.tryGetImage("gray_led_24.png");
            ImageResource.tryGetImage("red_led_24.png");
            ImageResource.tryGetImage("info_icon.png");
            ImageResource.tryGetImage("warning-bigger.png");
            ImageResource.tryGetImage("green_led_24.png");
            ImageResource.tryGetImage("yellow_led_24.png");
        }
    }

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="gray_led_24.png")
    public static @Key(value="gray_led_24.png") Icon grayLed24() {
        return ImageResource.tryGetImage("gray_led_24.png");
    }

    @Key(value="red_led_24.png")
    public static @Key(value="red_led_24.png") Icon redLed24() {
        return ImageResource.tryGetImage("red_led_24.png");
    }

    @Key(value="info_icon.png")
    public static @Key(value="info_icon.png") Icon infoIcon() {
        return ImageResource.tryGetImage("info_icon.png");
    }

    @Key(value="warning-bigger.png")
    public static @Key(value="warning-bigger.png") Icon warningBigger() {
        return ImageResource.tryGetImage("warning-bigger.png");
    }

    @Key(value="green_led_24.png")
    public static @Key(value="green_led_24.png") Icon greenLed24() {
        return ImageResource.tryGetImage("green_led_24.png");
    }

    @Key(value="yellow_led_24.png")
    public static @Key(value="yellow_led_24.png") Icon yellowLed24() {
        return ImageResource.tryGetImage("yellow_led_24.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

