/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.impl.installation;

import com.ur.polyscope.ethernetip.WatchdogAction;
import com.ur.polyscope.ethernetip.generated.ImageResource;
import com.ur.polyscope.ethernetip.generated.i18n.TextLabels;
import com.ur.polyscope.ethernetip.impl.daemon.DaemonState;
import com.ur.polyscope.ethernetip.impl.installation.ActionComboListener;
import com.ur.polyscope.ethernetip.impl.installation.DaemonStatusMessages;
import com.ur.polyscope.ethernetip.impl.installation.DisableButtonAction;
import com.ur.polyscope.ethernetip.impl.installation.EnableButtonAction;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPServiceExt;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPUIState;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPUIStateListener;
import com.ur.polyscope.ethernetip.impl.installation.UIStateHolder;
import com.ur.polyscope.ethernetip.impl.installation.UIUpdateCallBack;
import com.ur.polyscope.ethernetip.impl.installation.WatchDogLabelProvider;
import com.ur.polyscope.ethernetip.xmlrpc.UnknownResponseException;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.CardPanel;
import com.ur.swing.ComboBox;
import com.ur.swing.LabelProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.xmlrpc.XmlRpcException;
import org.jdesktop.swingx.JXLabel;

@Singleton
public class EthernetIPConfigurationTab
extends CardPanel
implements EthernetIPUIStateListener,
UIUpdateCallBack {
    private static final String STATUS_ICON_LABEL = "statusIconLabel";
    private static final String INFO_ICON_LABEL = "infoIconLabel";
    private static final String STATUS_LABEL = "statusLabel";
    private static final String ENABLE_BUTTON = "enableButton";
    private static final String DISABLE_BUTTON = "disableButton";
    private static final String PROGRAM_ACTION_COMBOBOX = "programActionOCombobox";
    private static final Logger LOG = LogFactory.createLogger(EthernetIPConfigurationTab.class);
    private static final Dimension BUTTON_SIZE = new Dimension(250, 40);
    private static final Dimension COMBO_SIZE = new Dimension(150, 29);
    private static final Dimension DESCRIPTION_SIZE = new Dimension(1080, 120);
    private final TextLabels textLabels;
    private final WidgetFactory widgetFactory;
    private final UIStateHolder uiStateHolder;
    private final EthernetIPServiceExt serviceExt;
    private final DaemonStatusMessages daemonStatusMessages;
    private JLabel statusIcon;
    private JButton enableButton;
    private JButton disableButton;
    private JLabel statusLabel;
    private ComboBox actionCombo;
    private JXLabel warningStatusLabel;
    private boolean shouldShowWarningStatusLabel;
    private Timer uiTimer;

    @Inject
    public EthernetIPConfigurationTab(ViewContext viewContext, TextLabels textLabels, EthernetIPServiceExt serviceExt, DaemonStatusMessages daemonStatusMessages, UIStateHolder uiStateHolder) {
        this.textLabels = textLabels;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.uiStateHolder = uiStateHolder;
        this.serviceExt = serviceExt;
        this.daemonStatusMessages = daemonStatusMessages;
        this.initComponents();
    }

    @Override
    public void stateChanged(UIStateHolder stateHolder) {
        this.updateComponents();
    }

    public void enter(Object o) {
        super.enter(o);
        this.uiTimer = new Timer(true);
        this.uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(EthernetIPConfigurationTab.this::updateComponents);
            }
        }, 500L, 1000L);
        this.updateComponents();
    }

    public Object exit() {
        if (this.uiTimer != null) {
            this.uiTimer.cancel();
            this.uiTimer = null;
        }
        return super.exit();
    }

    @Override
    public void updateUICallBack() {
        this.updateComponents();
    }

    void updateComponents() {
        EthernetIPSettings settings = this.serviceExt.getEthernetIPSettings();
        this.enableButton.setEnabled(!settings.isEnabled() && this.uiStateEnabled());
        this.disableButton.setEnabled(settings.isEnabled() && this.uiStateEnabled());
        this.updatePageHeader();
        this.updateComboBox();
        this.updateInformationText();
    }

    private boolean uiStateEnabled() {
        return EthernetIPUIState.ENABLED.equals((Object)this.uiStateHolder.getCurrentUIState());
    }

    private void updatePageHeader() {
        DaemonState daemonState = this.serviceExt.getDaemonState();
        EthernetIPSettings ethernetSettings = this.serviceExt.getEthernetIPSettings();
        boolean isConnected = this.isConnected();
        boolean isEthernetEnabled = ethernetSettings.isEnabled();
        this.updateStatusLabelAndIcon(daemonState, isConnected, isEthernetEnabled);
    }

    void updateStatusLabelAndIcon(DaemonState daemonState, boolean isConnected, boolean isEthernetEnabled) {
        String statusText = this.textLabels.connectionStatusDisabled();
        Icon statusIconImage = ImageResource.grayLed24();
        if (isEthernetEnabled) {
            switch (daemonState) {
                case RUNNING: {
                    statusText = isConnected ? this.textLabels.connectionStatusConnected() : this.textLabels.connectionStatusDaemonRunning();
                    statusIconImage = isConnected ? ImageResource.greenLed24() : ImageResource.yellowLed24();
                    break;
                }
                case STOPPED: {
                    statusText = this.textLabels.connectionStatusDaemonNotRunning();
                    statusIconImage = ImageResource.redLed24();
                    break;
                }
                case ERROR: {
                    statusText = this.textLabels.errorNoControllerConnection();
                    statusIconImage = ImageResource.redLed24();
                }
            }
        }
        this.statusLabel.setText(statusText);
        this.statusIcon.setIcon(statusIconImage);
    }

    protected boolean isConnected() {
        return this.getConnectionStatus() == ConnectionStatus.CONNECTED;
    }

    protected ConnectionStatus getConnectionStatus() {
        try {
            EthernetIPSettings ethernetSettings = this.serviceExt.getEthernetIPSettings();
            boolean isConnected = this.serviceExt.isConnected();
            if (ethernetSettings.isEnabled() && isConnected) {
                return ConnectionStatus.CONNECTED;
            }
            return ConnectionStatus.NOT_CONNECTED;
        }
        catch (UnknownResponseException | XmlRpcException e) {
            EthernetIPConfigurationTab.logConnectionException((Exception)e);
            return ConnectionStatus.UNKNOWN;
        }
    }

    private static void logConnectionException(Exception e) {
        String logTrace = "Ethernet/IP: Querying for connection state failed";
        LOG.trace(logTrace, (Throwable)e);
    }

    private void updateComboBox() {
        EthernetIPSettings settings = this.serviceExt.getEthernetIPSettings();
        this.actionCombo.setSelectedItem((Object)settings.getProgramAction());
        this.actionCombo.setEnabled(settings.isEnabled() && this.uiStateEnabled());
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setAlignmentX(0.0f);
        this.add(this.createPageHeader());
        this.add(this.createButtonPanel());
        this.add(this.createServiceMessagePanel());
        this.add(this.createDescriptionTextPanel());
        this.add(this.createDropDownPanel());
        this.add(this.createWarningPanel());
    }

    private JPanel createPageHeader() {
        this.statusIcon = this.widgetFactory.createLabel(ImageResource.grayLed24());
        this.statusIcon.setName(STATUS_ICON_LABEL);
        JLabel staticStatusLabel = this.widgetFactory.createPageTitle(String.valueOf(this.textLabels.ethernetIPAdapter()) + ":");
        this.statusLabel = this.widgetFactory.createPageTitle(this.textLabels.connectionStatusDaemonNotRunning());
        this.statusLabel.setName(STATUS_LABEL);
        JPanel pageHeaderPanel = new JPanel(new FlowLayout(3));
        pageHeaderPanel.add(Box.createHorizontalStrut(10));
        pageHeaderPanel.add(this.statusIcon);
        pageHeaderPanel.add(staticStatusLabel);
        pageHeaderPanel.add(Box.createHorizontalStrut(5));
        pageHeaderPanel.add(this.statusLabel);
        return pageHeaderPanel;
    }

    private JPanel createButtonPanel() {
        this.enableButton = this.widgetFactory.createButton((Action)new EnableButtonAction(this.serviceExt, this));
        this.enableButton.setName(ENABLE_BUTTON);
        this.enableButton.setText(this.textLabels.enable());
        this.setComponentSizes(this.enableButton, BUTTON_SIZE);
        this.disableButton = this.widgetFactory.createButton((Action)new DisableButtonAction(this.serviceExt, this));
        this.disableButton.setName(DISABLE_BUTTON);
        this.disableButton.setText(this.textLabels.disable());
        this.setComponentSizes(this.disableButton, BUTTON_SIZE);
        JPanel buttonsPanel = new JPanel(new FlowLayout(3));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(50, 40, 0, 0));
        buttonsPanel.add(this.enableButton);
        buttonsPanel.add(Box.createHorizontalStrut(8));
        buttonsPanel.add(this.disableButton);
        return buttonsPanel;
    }

    private JPanel createServiceMessagePanel() {
        JLabel infoIcon = this.widgetFactory.createLabel(ImageResource.infoIcon());
        infoIcon.setName(INFO_ICON_LABEL);
        JLabel serviceMessageLabel = this.widgetFactory.createLabel(this.textLabels.warningEnableServiceMessageLabel());
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 15, 0));
        infoIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        messagePanel.add((Component)infoIcon, "West");
        messagePanel.add((Component)serviceMessageLabel, "Center");
        JPanel messageTextPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(messageTextPanel, 3);
        messageTextPanel.setLayout(boxLayout);
        messageTextPanel.add(this.leftAlignWithFlow(messagePanel));
        return messageTextPanel;
    }

    private JPanel createDescriptionTextPanel() {
        String descriptionTitle = this.textLabels.installationScreenDescriptionTitle();
        String descriptionGrayIndicator = this.textLabels.installationScreenDescriptionGrayIndicator();
        String descriptionYellowIndicator = this.textLabels.installationScreenDescriptionYellowIndicator();
        String descriptionGreenIndicator = this.textLabels.installationScreenDescriptionGreenIndicator();
        JLabel titleLabel = this.widgetFactory.createLabel(descriptionTitle);
        JList<String> statusList = new JList<String>(new String[]{"\u2022 " + descriptionGrayIndicator, "\u2022 " + descriptionYellowIndicator, "\u2022 " + descriptionGreenIndicator});
        statusList.setCellRenderer(new BulletPointListCellRenderer());
        statusList.setBorder(BorderFactory.createEmptyBorder());
        statusList.setSelectionModel(new DisabledItemSelectionModel());
        statusList.setForeground(UIManager.getColor("UR.foreground"));
        JPanel actionTextPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(actionTextPanel, 1);
        actionTextPanel.setLayout(boxLayout);
        actionTextPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 25, 0));
        actionTextPanel.setPreferredSize(DESCRIPTION_SIZE);
        actionTextPanel.setMaximumSize(actionTextPanel.getPreferredSize());
        actionTextPanel.add(this.leftAlignWithFlow(titleLabel));
        actionTextPanel.add(this.createIndentationPanel(statusList));
        return actionTextPanel;
    }

    private JPanel createIndentationPanel(Component component) {
        JPanel indentationPanel = new JPanel(new BorderLayout());
        indentationPanel.add(Box.createHorizontalStrut(28), "West");
        indentationPanel.add(component, "Center");
        indentationPanel.setBorder(BorderFactory.createEmptyBorder());
        return indentationPanel;
    }

    private JPanel createDropDownPanel() {
        JLabel watchdogActionLabel = this.widgetFactory.createLabel(this.textLabels.watchdogActionLabel());
        this.actionCombo = this.widgetFactory.createComboBox((LabelProvider)new WatchDogLabelProvider(this.textLabels), (Object[])WatchdogAction.values());
        this.actionCombo.addActionListener((ActionListener)new ActionComboListener(this.serviceExt, this));
        this.setComponentSizes((JComponent)this.actionCombo, COMBO_SIZE);
        this.actionCombo.setName(PROGRAM_ACTION_COMBOBOX);
        JPanel comboAndTextPanel = new JPanel(new FlowLayout(3));
        comboAndTextPanel.add(this.createComboWithLabelPanel(this.actionCombo, watchdogActionLabel));
        comboAndTextPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 20, 0));
        return comboAndTextPanel;
    }

    private JPanel createComboWithLabelPanel(ComboBox comboBox, JLabel label) {
        JPanel comboLabelPanel = new JPanel();
        comboLabelPanel.setLayout(new BoxLayout(comboLabelPanel, 3));
        comboLabelPanel.add(this.leftAlignWithFlow(label));
        comboLabelPanel.add(this.leftAlignWithFlow((JComponent)comboBox));
        return comboLabelPanel;
    }

    private JPanel createWarningPanel() {
        JPanel warningPanel = new JPanel(new BorderLayout());
        this.warningStatusLabel = new JXLabel();
        this.warningStatusLabel.setLineWrap(true);
        this.warningStatusLabel.setIcon(ImageResource.warningBigger());
        this.warningStatusLabel.add(Box.createHorizontalStrut(8));
        this.warningStatusLabel.setVerticalTextPosition(1);
        this.warningStatusLabel.setVisible(false);
        warningPanel.add((Component)this.warningStatusLabel, "West");
        warningPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 130, 0));
        return this.leftAlignWithFlow(warningPanel);
    }

    List<String> getStatusMessages(EthernetIPSettings settings) {
        try {
            if (settings.isEnabled()) {
                List<Integer> msgCodes = this.serviceExt.getStatusMessages();
                ArrayList<String> result = new ArrayList<String>();
                for (Integer i : msgCodes) {
                    result.add(this.daemonStatusMessages.getStatusMessage(i));
                }
                return result;
            }
        }
        catch (UnknownResponseException | XmlRpcException e) {
            EthernetIPConfigurationTab.logConnectionException((Exception)e);
        }
        return new ArrayList<String>();
    }

    private void updateInformationText() {
        EthernetIPSettings settings = this.serviceExt.getEthernetIPSettings();
        this.shouldShowWarningStatusLabel = false;
        String prev = this.warningStatusLabel.getText();
        StringBuilder statusMessageStringBuilder = this.createStatusMessageStringBuilder();
        this.appendStatusMessages(statusMessageStringBuilder, this.getStatusMessages(settings));
        this.updateWarningStatusLabelIfTextHasChanged(prev, statusMessageStringBuilder);
        this.setWarningStatusLabelVisibleIfStatusTextShouldBeShown();
    }

    private StringBuilder createStatusMessageStringBuilder() {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(this.textLabels.warningHeader()).append(":<br><br>");
        return sb;
    }

    void appendStatusMessages(StringBuilder statusMessageStringBuilder, List<String> statusMessages) {
        if (statusMessages.isEmpty()) {
            return;
        }
        this.shouldShowWarningStatusLabel = true;
        for (String message : statusMessages) {
            String[] lines;
            String[] stringArray = lines = message.split("<br/>");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                statusMessageStringBuilder.append("\u2022 ").append(line.trim()).append("<br>");
                ++n2;
            }
        }
        statusMessageStringBuilder.append("</html>");
    }

    private void setWarningStatusLabelVisibleIfStatusTextShouldBeShown() {
        if (this.warningStatusLabel.isVisible() != this.shouldShowWarningStatusLabel) {
            this.warningStatusLabel.setVisible(this.shouldShowWarningStatusLabel);
        }
    }

    void updateWarningStatusLabelIfTextHasChanged(String prev, StringBuilder stringBuilder) {
        if (!stringBuilder.toString().equals(prev)) {
            this.warningStatusLabel.setText(stringBuilder.toString());
        }
    }

    private JPanel leftAlignWithFlow(JComponent component) {
        JPanel leftAlignedPanel = new JPanel(new FlowLayout(0));
        leftAlignedPanel.add(component);
        return leftAlignedPanel;
    }

    private void setComponentSizes(JComponent component, Dimension dimension) {
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
    }

    ComboBox getCombo() {
        return this.actionCombo;
    }

    JButton getDisableButton() {
        return this.disableButton;
    }

    JButton getEnableButton() {
        return this.enableButton;
    }

    JLabel getStatusIcon() {
        return this.statusIcon;
    }

    JLabel getStatusLabel() {
        return this.statusLabel;
    }

    JLabel getWarningLabel() {
        return this.warningStatusLabel;
    }

    boolean shouldShowWarningStatusLabel() {
        return this.shouldShowWarningStatusLabel;
    }

    private static class BulletPointListCellRenderer
    extends DefaultListCellRenderer {
        private BulletPointListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            renderer.setBorder(BorderFactory.createLineBorder(null, 0));
            return renderer;
        }
    }

    protected static enum ConnectionStatus {
        UNKNOWN,
        NOT_CONNECTED,
        CONNECTED;

    }

    private static class DisabledItemSelectionModel
    extends DefaultListSelectionModel {
        private DisabledItemSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(-1, -1);
        }
    }
}

