/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.impl.installation;

import com.ur.polyscope.ethernetip.WatchdogAction;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPServiceExt;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;

public class EthernetIPConversionStrategy
extends ConversionStrategyTemplate<EthernetIPSettings>
implements InstallationComponentConversionStrategy<EthernetIPSettings> {
    static final String ENABLED = "enabled";
    static final String PROGRAM_ACTION = "programAction";
    static final String ETHERNETIP = "EthernetIP";
    private final EthernetIPServiceExt ethernetIPServiceExt;

    @Inject
    public EthernetIPConversionStrategy(EthernetIPServiceExt ethernetIPServiceExt) {
        super(EthernetIPSettings.class);
        this.ethernetIPServiceExt = ethernetIPServiceExt;
    }

    public void marshal(EthernetIPSettings ethernetIPSettings, PersistWriter writer) {
        writer.addAttribute(ENABLED, ethernetIPSettings.isEnabled());
        writer.addAttribute(PROGRAM_ACTION, (Enum)ethernetIPSettings.getProgramAction());
    }

    public EthernetIPSettings unmarshal(PersistReader reader) {
        EthernetIPSettings result = new EthernetIPSettings(this.ethernetIPServiceExt);
        result.loadEnabled(reader.getBooleanAttribute(ENABLED));
        result.loadProgramAction((WatchdogAction)reader.getEnumAttribute(PROGRAM_ACTION, WatchdogAction.class));
        return result;
    }

    public Map<String, Class<? extends EthernetIPSettings>> getClassAliases(boolean forMarshalling) {
        LinkedHashMap<String, Class<? extends EthernetIPSettings>> aliasMap = new LinkedHashMap<String, Class<? extends EthernetIPSettings>>();
        aliasMap.put(ETHERNETIP, EthernetIPSettings.class);
        return aliasMap;
    }
}

