/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.impl.installation;

import com.ur.polyscope.ethernetip.WatchdogAction;
import com.ur.polyscope.ethernetip.impl.daemon.DaemonService;
import com.ur.polyscope.ethernetip.impl.daemon.DaemonState;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPServiceExt;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPUIState;
import com.ur.polyscope.ethernetip.impl.installation.UIStateHolder;
import com.ur.polyscope.ethernetip.installation.EthernetIPService;
import com.ur.polyscope.ethernetip.xmlrpc.EthernetIP;
import com.ur.polyscope.ethernetip.xmlrpc.UnknownResponseException;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.xmlrpc.XmlRpcException;

public class EthernetIPServiceImpl
implements EthernetIPService,
EthernetIPServiceExt {
    private static final String ETHERNET_SERVICE = "urethernetip";
    protected static final String WATCHDOG_ACTION_PROGRAM = "watchdogAction";
    protected static final String UN_SET = "UN_SET";
    protected static final String ENABLED_KEY = "enabled";
    private final UIStateHolder uiStateHolder;
    private final UnderwayInstallationProvider underwayInstallationProvider;
    private final EthernetIP ethernetIP;
    private final DaemonService daemonService;

    @Inject
    public EthernetIPServiceImpl(UIStateHolder uiStateHolder, UnderwayInstallationProvider underwayInstallationProvider, EthernetIP ethernetIP, DaemonService daemonService) {
        this.uiStateHolder = uiStateHolder;
        this.underwayInstallationProvider = underwayInstallationProvider;
        this.ethernetIP = ethernetIP;
        this.daemonService = daemonService;
    }

    public EthernetIPUIState getEthernetIPUIState() {
        return this.uiStateHolder.getCurrentUIState();
    }

    public void loadLegacyEthernetIPSettings(TypedOptionsSection typedOptionsSection) {
        EthernetIPSettings ethernetIPSettings = this.getEthernetIPSettings();
        ethernetIPSettings.loadEnabled(typedOptionsSection.getBoolean(ENABLED_KEY, Boolean.valueOf(false)));
        ethernetIPSettings.loadProgramAction(this.getWatchdogAction(WATCHDOG_ACTION_PROGRAM, typedOptionsSection));
    }

    @Override
    public EthernetIPSettings getEthernetIPSettings() {
        return (EthernetIPSettings)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(EthernetIPSettings.class);
    }

    private WatchdogAction getWatchdogAction(String idKey, TypedOptionsSection typedOptionsSection) {
        WatchdogAction result = WatchdogAction.PAUSE;
        String watchdogActionName = typedOptionsSection.getString(idKey, UN_SET);
        if (watchdogActionName.equals(UN_SET)) {
            result = WatchdogAction.IGNORE;
        } else {
            try {
                result = WatchdogAction.valueOf(watchdogActionName);
            }
            catch (IllegalArgumentException e) {
                Log.error((String)("ETHERNET/IP: Watchdog action " + watchdogActionName + " not recognized"), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void startEthernetIPDaemon() {
        try {
            this.daemonService.startService();
        }
        catch (IOException e) {
            Log.error((String)"Failed to start service urethernetip", (Throwable)e);
        }
    }

    @Override
    public void stopEthernetIPDaemon() {
        try {
            if (this.getEthernetIPUIState() == EthernetIPUIState.ENABLED) {
                this.daemonService.stopService();
            }
        }
        catch (IOException e) {
            Log.error((String)"Failed to stop service urethernetip", (Throwable)e);
        }
    }

    @Override
    public DaemonState getDaemonState() {
        try {
            return this.daemonService.getState();
        }
        catch (IOException e) {
            Log.error((String)"Failed to get status of urethernetip service", (Throwable)e);
            return DaemonState.ERROR;
        }
    }

    @Override
    public boolean isConnected() throws XmlRpcException, UnknownResponseException {
        return this.ethernetIP.isConnected();
    }

    @Override
    public List<Integer> getStatusMessages() throws XmlRpcException, UnknownResponseException {
        return this.ethernetIP.getStatusMessages();
    }
}

