/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.impl.installation;

import com.ur.polyscope.ethernetip.RTInputData;
import com.ur.polyscope.ethernetip.WatchdogAction;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPServiceExt;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings$AjcClosure1;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings$AjcClosure3;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.Locale;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class EthernetIPSettings
implements InstallationComponent,
PreambleScript {
    private static final float WATCHDOG_MINIMAL_FREQUENCY = 10.0f;
    private final EthernetIPServiceExt serviceExt;
    private boolean enabled = false;
    private WatchdogAction programAction = WatchdogAction.PAUSE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Inject
    public EthernetIPSettings(EthernetIPServiceExt serviceExt) {
        this.serviceExt = serviceExt;
    }

    public Class<?> getType() {
        return EthernetIPSettings.class;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void loadEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.serviceExt.startEthernetIPDaemon();
        } else {
            this.serviceExt.stopEthernetIPDaemon();
        }
    }

    public void loadProgramAction(WatchdogAction programAction) {
        this.programAction = programAction;
    }

    @InstallationChangedEvent
    public void setEnabled(boolean enabled) {
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        EthernetIPSettings$AjcClosure1 ethernetIPSettings$AjcClosure1 = new EthernetIPSettings$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(ethernetIPSettings$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @InstallationChangedEvent
    public void setProgramAction(WatchdogAction action) {
        WatchdogAction watchdogAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)watchdogAction));
        Object[] objectArray = new Object[]{this, watchdogAction, joinPoint};
        EthernetIPSettings$AjcClosure3 ethernetIPSettings$AjcClosure3 = new EthernetIPSettings$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(ethernetIPSettings$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public WatchdogAction getProgramAction() {
        return this.programAction;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        if (this.isEnabled()) {
            this.appendWatchdogActionScript(writer, this.programAction, RTInputData.speed_slider_mask.name());
        }
    }

    private void appendWatchdogActionScript(ScriptWriter scriptWriter, WatchdogAction watchdogAction, String moduleRegister) {
        if (!watchdogAction.equals((Object)WatchdogAction.IGNORE)) {
            scriptWriter.appendLine("rtde_set_watchdog(\"" + moduleRegister + "\", " + 10.0f + ", \"" + watchdogAction.name().toLowerCase(Locale.ENGLISH) + "\")");
        }
    }

    static {
        EthernetIPSettings.ajc$preClinit();
    }

    static final /* synthetic */ void setEnabled_aroundBody0(EthernetIPSettings ajc$this, boolean enabled, JoinPoint joinPoint) {
        ajc$this.loadEnabled(enabled);
    }

    static final /* synthetic */ void setProgramAction_aroundBody2(EthernetIPSettings ajc$this, WatchdogAction action, JoinPoint joinPoint) {
        ajc$this.loadProgramAction(action);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthernetIPSettings.java", EthernetIPSettings.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEnabled", "com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings", "boolean", "enabled", "", "void"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProgramAction", "com.ur.polyscope.ethernetip.impl.installation.EthernetIPSettings", "com.ur.polyscope.ethernetip.WatchdogAction", "action", "", "void"), 59);
    }
}

