/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.impl.installation;

import com.ur.polyscope.ethernetip.impl.installation.EthernetIPUIState;
import com.ur.polyscope.ethernetip.impl.installation.EthernetIPUIStateListener;
import com.ur.util.event.EventManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UIStateHolder {
    private final EventManager eventManager;
    private EthernetIPUIState currentUIState = EthernetIPUIState.ENABLED;

    @Inject
    public UIStateHolder(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public EthernetIPUIState getCurrentUIState() {
        return this.currentUIState;
    }

    public void setCurrentUIState(EthernetIPUIState newUIState) {
        this.currentUIState = newUIState;
        this.notifyStateChange();
    }

    private void notifyStateChange() {
        this.eventManager.fireEvent(EthernetIPUIStateListener.class, ethernetIPUIStateListener -> ethernetIPUIStateListener.stateChanged(this));
    }
}

