/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.ethernetip.xmlrpc;

import com.ur.polyscope.ethernetip.xmlrpc.EthernetIP;
import com.ur.polyscope.ethernetip.xmlrpc.Response;
import com.ur.polyscope.ethernetip.xmlrpc.UnknownResponseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XMLRPCEthernetIP
implements EthernetIP {
    private static final String DEFAULT_DAEMON_IP = "127.0.0.1";
    private static final int DEFAULT_DAEMON_PORT = 40000;
    XmlRpcClient client;

    @Inject
    public XMLRPCEthernetIP() {
        this(DEFAULT_DAEMON_IP, 40000);
    }

    protected XMLRPCEthernetIP(String host, int port) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(true);
        try {
            config.setServerURL(new URL("http://" + host + ":" + port + "/RPC2"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        config.setConnectionTimeout(1000);
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)config);
    }

    @Override
    public boolean isConnected() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("is_connected", new ArrayList());
        return Response.processBoolean(result);
    }

    @Override
    public List<Integer> getStatusMessages() throws XmlRpcException, UnknownResponseException {
        Object result = this.client.execute("get_status_messages", new ArrayList());
        return Response.processIntegerArray(result);
    }
}

