/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.program.metrics.internal.ProgramStatisticStorage;
import com.ur.polyscope.program.monitor.ProgramInfo;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.util.event.Subscription;
import javax.inject.Inject;

class ProgramInfoListener {
    private final Recipe<ProgramInfo> programInfoRecipe;
    private final ProgramStatisticStorage programStatisticStorage;

    @Inject
    ProgramInfoListener(@Source(value=ProgramInfo.class) Recipe<ProgramInfo> programInfoRecipe, ProgramStatisticStorage programStatisticStorage) {
        this.programInfoRecipe = programInfoRecipe;
        this.programStatisticStorage = programStatisticStorage;
    }

    Subscription subscribe() {
        return this.programInfoRecipe.subscribe((Consumer)new Consumer<ProgramInfo>(){

            public void accept(ProgramInfo programInfo) {
                if (programInfo.programState == ProgramState.PLAYING) {
                    ProgramInfoListener.this.programStatisticStorage.programStarted(programInfo.mainProgramNode);
                } else {
                    ProgramInfoListener.this.programStatisticStorage.programFinished();
                }
            }
        });
    }
}

