/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.metrics.internal.NodeOccurrences;
import com.ur.polyscope.program.nodes.ProgramNode;
import com.ur.util.logging.Log;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ProgramInvocations {
    private static final long SIGNIFICANCE_THRESHOLD_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long SNAPSHOT_FREQUENCY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final int NOT_STARTED = -1;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    @JsonProperty(value="nodes")
    NodeOccurrences nodeOccurrences = new NodeOccurrences();
    @JsonProperty(value="invocations")
    private long count;
    @JsonProperty
    private long runtimeSeconds;
    private long programStart = -1L;
    private long newRuntimeMillis;
    private long newInvocations;
    private ScheduledFuture snapshotSchedule;

    ProgramInvocations() {
    }

    ProgramInvocations(ProgramRootNode programRootNode) {
        this.populateNodeOccurrences(programRootNode.asGeneric());
    }

    private void populateNodeOccurrences(ProgramNode.GenericProgramNode node) {
        this.nodeOccurrences.addNodeStatistic(node);
        for (ProgramNode.GenericProgramNode child : node) {
            this.populateNodeOccurrences(child);
        }
    }

    @JsonIgnore
    long getSignificanceThresholdMillis() {
        String property = System.getProperty("SignificanceThresholdMillis");
        if (property != null) {
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                Log.error((String)("SignificanceThresholdMillis system property cannot be parsed, defaulting to " + SIGNIFICANCE_THRESHOLD_MILLIS), (Throwable)e);
            }
        }
        return SIGNIFICANCE_THRESHOLD_MILLIS;
    }

    @JsonIgnore
    long getSnapshotFrequencyMillis() {
        return SNAPSHOT_FREQUENCY_MILLIS;
    }

    void invocationStarted() {
        this.stopSnapshotTaskIfActive();
        this.programStart = System.currentTimeMillis();
        this.snapshotSchedule = SCHEDULER.scheduleAtFixedRate(new TakeSnapshotTask(this), this.getSignificanceThresholdMillis(), this.getSnapshotFrequencyMillis(), TimeUnit.MILLISECONDS);
    }

    void invocationFinished() {
        this.stopSnapshotTaskIfActive();
        this.takeSnapshot();
        this.persistSnapshot();
        this.removeSnapshot();
    }

    private void stopSnapshotTaskIfActive() {
        if (this.snapshotSchedule != null && !this.snapshotSchedule.isDone()) {
            this.snapshotSchedule.cancel(false);
        }
    }

    private synchronized void takeSnapshot() {
        if (this.isSignificant()) {
            this.newInvocations = 1L;
            this.newRuntimeMillis = this.getTimeSinceProgramStart();
        }
    }

    long getTimeSinceProgramStart() {
        if (!this.isStarted()) {
            return -1L;
        }
        return System.currentTimeMillis() - this.programStart;
    }

    private boolean isStarted() {
        return this.programStart != -1L;
    }

    boolean isSignificant() {
        return this.isStarted() && this.getTimeSinceProgramStart() >= this.getSignificanceThresholdMillis();
    }

    private synchronized void persistSnapshot() {
        this.count = this.getCount();
        this.runtimeSeconds = this.getRuntimeSeconds();
    }

    private synchronized void removeSnapshot() {
        this.newInvocations = 0L;
        this.newRuntimeMillis = 0L;
        this.programStart = -1L;
    }

    @JsonProperty
    public long getRuntimeSeconds() {
        return this.runtimeSeconds + TimeUnit.MILLISECONDS.toSeconds(this.newRuntimeMillis);
    }

    @JsonProperty(value="invocations")
    public long getCount() {
        return this.count + this.newInvocations;
    }

    private static class TakeSnapshotTask
    implements Runnable {
        private final ProgramInvocations invocations;

        TakeSnapshotTask(ProgramInvocations invocations) {
            this.invocations = invocations;
        }

        @Override
        public void run() {
            this.invocations.takeSnapshot();
        }
    }
}

