/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.ur.polyscope.program.metrics.internal.ProgramInvocations;
import com.ur.util.logging.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ProgramStatistic
extends ConcurrentHashMap<String, ProgramInvocations> {
    private static final long serialVersionUID = 1L;

    ProgramStatistic() {
    }

    void removeInvocationsWithMinimalRuntime() {
        long minimalRuntime = Long.MAX_VALUE;
        String keyToRemove = null;
        for (Map.Entry entry : this.entrySet()) {
            long runtimeSeconds = ((ProgramInvocations)entry.getValue()).getRuntimeSeconds();
            if (runtimeSeconds >= minimalRuntime) continue;
            keyToRemove = (String)entry.getKey();
            minimalRuntime = runtimeSeconds;
        }
        if (keyToRemove != null) {
            Log.debug((String)("Removing statistic key " + keyToRemove + " with minimal runtime " + minimalRuntime));
            this.remove(keyToRemove);
        }
    }
}

