/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.metrics.internal.ProgramInvocations;
import com.ur.polyscope.program.metrics.internal.WritableProgramStatisticFile;
import com.ur.polyscope.program.nodes.ProgramNode;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public class ProgramStatisticStorage {
    private static final long SAVE_RATE_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final WritableProgramStatisticFile programStatistic = this.createProgramStatisticFile();
    private String currentProgramKey;
    private ProgramInvocations currentProgramInvocations;

    WritableProgramStatisticFile createProgramStatisticFile() {
        return new WritableProgramStatisticFile();
    }

    public WritableProgramStatisticFile getStatisticsFile() {
        return this.programStatistic;
    }

    long getSaveRateMillis() {
        return SAVE_RATE_MILLIS;
    }

    Subscription startSaving() {
        this.scheduler.scheduleAtFixedRate(new ProgramStatisticFileSaveTask(), 0L, this.getSaveRateMillis(), TimeUnit.MILLISECONDS);
        return new Subscription(){

            public void dispose() {
                ProgramStatisticStorage.this.scheduler.shutdown();
            }
        };
    }

    synchronized void programStarted(ProgramRootNode programRootNode) {
        this.programFinished();
        if (programRootNode == null) {
            return;
        }
        this.currentProgramKey = ProgramStatisticStorage.calculateMd5Hex(programRootNode);
        this.currentProgramInvocations = this.getOrCreateProgramInvocations(this.currentProgramKey, programRootNode);
        this.currentProgramInvocations.invocationStarted();
    }

    ProgramInvocations getOrCreateProgramInvocations(String programKey, ProgramRootNode programRootNode) {
        ProgramInvocations programInvocations = this.programStatistic.get(programKey);
        if (programInvocations == null) {
            programInvocations = new ProgramInvocations(programRootNode);
        }
        return programInvocations;
    }

    private static String calculateMd5Hex(ProgramRootNode programRootNode) {
        ProgramNode.GenericProgramNode genericProgramNode = programRootNode.asGeneric();
        return ProgramStatisticStorage.calculateMd5Hex(genericProgramNode.toString());
    }

    private static String calculateMd5Hex(String s) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(s.getBytes());
            return String.format("%032x", new BigInteger(1, messageDigest.digest())).toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm is required", e);
        }
    }

    synchronized void programFinished() {
        if (this.isProgramUnknown()) {
            return;
        }
        this.persistSignificantStatistic();
        this.currentProgramInvocations.invocationFinished();
        this.currentProgramKey = null;
        this.currentProgramInvocations = null;
    }

    private boolean isProgramUnknown() {
        return this.currentProgramKey == null || this.currentProgramInvocations == null;
    }

    private synchronized void persistSignificantStatistic() {
        if (this.isProgramUnknown()) {
            return;
        }
        if (this.currentProgramInvocations.isSignificant()) {
            this.programStatistic.put(this.currentProgramKey, this.currentProgramInvocations);
        }
    }

    private class ProgramStatisticFileSaveTask
    implements Runnable {
        private ProgramStatisticFileSaveTask() {
        }

        @Override
        public void run() {
            ProgramStatisticStorage.this.persistSignificantStatistic();
            try {
                ProgramStatisticStorage.this.programStatistic.write();
            }
            catch (IOException e) {
                Log.warning((String)"Program statistic cannot be persisted", (Throwable)e);
            }
        }
    }
}

