/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.program.metrics.internal.ProgramStatisticStorage;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class ProgramStatisticsProbe
implements FlightRecorderProbe {
    private final FlightRecorderAttachmentFactory attachmentFactory;
    private final ProgramStatisticStorage programStatisticStorage;

    @Inject
    public ProgramStatisticsProbe(FlightRecorderAttachmentFactory attachmentFactory, ProgramStatisticStorage programStatisticStorage) {
        this.attachmentFactory = attachmentFactory;
        this.programStatisticStorage = programStatisticStorage;
    }

    public String getName() {
        return "Metrics";
    }

    public void write(PrintStream printStream) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector attachments = new AttachmentCollector(this.attachmentFactory);
        FileAttachmentConfiguration attachmentConfiguration = this.attachmentFactory.getFileAttachmentConfiguration();
        attachmentConfiguration.setFile(this.programStatisticStorage.getStatisticsFile().getFile()).setMimeType(MediaType.GZIP.toString());
        attachments.collect(this.attachmentFactory.getTextFileAttachment(attachmentConfiguration));
        return attachments.asList();
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
    }
}

