/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.metrics.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.disk.Directories;
import com.ur.lang.IOUtil;
import com.ur.polyscope.program.metrics.internal.ProgramInvocations;
import com.ur.polyscope.program.metrics.internal.ProgramStatistic;
import com.ur.util.logging.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class WritableProgramStatisticFile {
    private static final long FILE_MAX_LENGTH = 524288L;
    private final ObjectMapper mapper = new ObjectMapper();
    private final File file;
    private ProgramStatistic content;

    WritableProgramStatisticFile() {
        this(Directories.home());
    }

    WritableProgramStatisticFile(File homeFolder) {
        this.file = WritableProgramStatisticFile.file(homeFolder, "psm.ura");
        this.content = this.tryRead(this.file);
    }

    ProgramInvocations get(String programMd5Hex) {
        return (ProgramInvocations)this.content.get(programMd5Hex);
    }

    void put(String programMd5Hex, ProgramInvocations programInvocations) {
        this.content.put(programMd5Hex, programInvocations);
        if (this.isFull()) {
            this.content.removeInvocationsWithMinimalRuntime();
        }
    }

    public File getFile() {
        return this.file;
    }

    boolean isEmpty() {
        return this.content.isEmpty();
    }

    boolean isFull() {
        return this.file.length() >= 524288L;
    }

    void write() throws IOException {
        FileOutputStream fileOutputStream = null;
        GZIPOutputStream gzipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.file);
            gzipOutputStream = new GZIPOutputStream(fileOutputStream);
            this.mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)gzipOutputStream, (Object)this.content);
        }
        catch (Throwable throwable) {
            IOUtil.close(gzipOutputStream);
            IOUtil.close((Closeable)fileOutputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)gzipOutputStream);
        IOUtil.close((Closeable)fileOutputStream);
    }

    private static File file(File homeFolder, String fileName) {
        File flightReportsPath = new File(homeFolder, "flightreports");
        if (!flightReportsPath.exists()) {
            flightReportsPath.mkdir();
        }
        return new File(flightReportsPath, fileName);
    }

    private ProgramStatistic tryRead(File file) {
        if (file.exists()) {
            try {
                return this.read(file);
            }
            catch (IOException ioe) {
                Log.warning((String)("Error reading statistic file. Returning empty: " + file.getPath()), (Throwable)ioe);
                return new ProgramStatistic();
            }
        }
        return new ProgramStatistic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgramStatistic read(File file) throws IOException {
        ProgramStatistic programStatistic;
        FileInputStream fileInputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            gzipInputStream = new GZIPInputStream(fileInputStream);
            programStatistic = (ProgramStatistic)this.mapper.readValue((InputStream)gzipInputStream, ProgramStatistic.class);
        }
        catch (Throwable throwable) {
            IOUtil.close(gzipInputStream);
            IOUtil.close((Closeable)fileInputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)gzipInputStream);
        IOUtil.close((Closeable)fileInputStream);
        return programStatistic;
    }
}

