/*
 * Decompiled with CFR 0.152.
 */
package com.ur.resources;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IllustrationImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            IllustrationImageResource.tryGetImage("twoDimensional.png");
            IllustrationImageResource.tryGetImage("smoothMotionIllustration.png");
            IllustrationImageResource.tryGetImage("grid2pos3d.png");
            IllustrationImageResource.tryGetImage("grid5pos3d.png");
            IllustrationImageResource.tryGetImage("grid4pos2d.png");
            IllustrationImageResource.tryGetImage("grid6pos3d.png");
            IllustrationImageResource.tryGetImage("grid3pos3d.png");
            IllustrationImageResource.tryGetImage("teach_plane_2.png");
            IllustrationImageResource.tryGetImage("grid8pos3d.png");
            IllustrationImageResource.tryGetImage("oneDimensional.png");
            IllustrationImageResource.tryGetImage("grid1pos1d.png");
            IllustrationImageResource.tryGetImage("grid2pos2d.png");
            IllustrationImageResource.tryGetImage("destack.png");
            IllustrationImageResource.tryGetImage("grid1pos3d.png");
            IllustrationImageResource.tryGetImage("grid2pos1d.png");
            IllustrationImageResource.tryGetImage("grid7pos3d.png");
            IllustrationImageResource.tryGetImage("grid4pos3d.png");
            IllustrationImageResource.tryGetImage("teach_plane_3.png");
            IllustrationImageResource.tryGetImage("grid3pos2d.png");
            IllustrationImageResource.tryGetImage("threeDimensional.png");
            IllustrationImageResource.tryGetImage("move-tool-contact-description.png");
            IllustrationImageResource.tryGetImage("stack.png");
            IllustrationImageResource.tryGetImage("zeroDimensional.png");
            IllustrationImageResource.tryGetImage("smooth_transition_graph.png");
            IllustrationImageResource.tryGetImage("grid1pos2d.png");
            IllustrationImageResource.tryGetImage("teach_plane_1.png");
            IllustrationImageResource.tryGetImage("movecConstant.png");
            IllustrationImageResource.tryGetImage("teach_plane_all.png");
            IllustrationImageResource.tryGetImage("tool_wrench.png");
            IllustrationImageResource.tryGetImage("movecNotConstant.png");
        }
    }

    private IllustrationImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/resources/images/illustrations/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="twoDimensional.png")
    public static @Key(value="twoDimensional.png") Icon twoDimensional() {
        return IllustrationImageResource.tryGetImage("twoDimensional.png");
    }

    @Key(value="smoothMotionIllustration.png")
    public static @Key(value="smoothMotionIllustration.png") Icon smoothMotionIllustration() {
        return IllustrationImageResource.tryGetImage("smoothMotionIllustration.png");
    }

    @Key(value="grid2pos3d.png")
    public static @Key(value="grid2pos3d.png") Icon grid2pos3d() {
        return IllustrationImageResource.tryGetImage("grid2pos3d.png");
    }

    @Key(value="grid5pos3d.png")
    public static @Key(value="grid5pos3d.png") Icon grid5pos3d() {
        return IllustrationImageResource.tryGetImage("grid5pos3d.png");
    }

    @Key(value="grid4pos2d.png")
    public static @Key(value="grid4pos2d.png") Icon grid4pos2d() {
        return IllustrationImageResource.tryGetImage("grid4pos2d.png");
    }

    @Key(value="grid6pos3d.png")
    public static @Key(value="grid6pos3d.png") Icon grid6pos3d() {
        return IllustrationImageResource.tryGetImage("grid6pos3d.png");
    }

    @Key(value="grid3pos3d.png")
    public static @Key(value="grid3pos3d.png") Icon grid3pos3d() {
        return IllustrationImageResource.tryGetImage("grid3pos3d.png");
    }

    @Key(value="teach_plane_2.png")
    public static @Key(value="teach_plane_2.png") Icon teachPlane2() {
        return IllustrationImageResource.tryGetImage("teach_plane_2.png");
    }

    @Key(value="grid8pos3d.png")
    public static @Key(value="grid8pos3d.png") Icon grid8pos3d() {
        return IllustrationImageResource.tryGetImage("grid8pos3d.png");
    }

    @Key(value="oneDimensional.png")
    public static @Key(value="oneDimensional.png") Icon oneDimensional() {
        return IllustrationImageResource.tryGetImage("oneDimensional.png");
    }

    @Key(value="grid1pos1d.png")
    public static @Key(value="grid1pos1d.png") Icon grid1pos1d() {
        return IllustrationImageResource.tryGetImage("grid1pos1d.png");
    }

    @Key(value="grid2pos2d.png")
    public static @Key(value="grid2pos2d.png") Icon grid2pos2d() {
        return IllustrationImageResource.tryGetImage("grid2pos2d.png");
    }

    @Key(value="destack.png")
    public static @Key(value="destack.png") Icon destack() {
        return IllustrationImageResource.tryGetImage("destack.png");
    }

    @Key(value="grid1pos3d.png")
    public static @Key(value="grid1pos3d.png") Icon grid1pos3d() {
        return IllustrationImageResource.tryGetImage("grid1pos3d.png");
    }

    @Key(value="grid2pos1d.png")
    public static @Key(value="grid2pos1d.png") Icon grid2pos1d() {
        return IllustrationImageResource.tryGetImage("grid2pos1d.png");
    }

    @Key(value="grid7pos3d.png")
    public static @Key(value="grid7pos3d.png") Icon grid7pos3d() {
        return IllustrationImageResource.tryGetImage("grid7pos3d.png");
    }

    @Key(value="grid4pos3d.png")
    public static @Key(value="grid4pos3d.png") Icon grid4pos3d() {
        return IllustrationImageResource.tryGetImage("grid4pos3d.png");
    }

    @Key(value="teach_plane_3.png")
    public static @Key(value="teach_plane_3.png") Icon teachPlane3() {
        return IllustrationImageResource.tryGetImage("teach_plane_3.png");
    }

    @Key(value="grid3pos2d.png")
    public static @Key(value="grid3pos2d.png") Icon grid3pos2d() {
        return IllustrationImageResource.tryGetImage("grid3pos2d.png");
    }

    @Key(value="threeDimensional.png")
    public static @Key(value="threeDimensional.png") Icon threeDimensional() {
        return IllustrationImageResource.tryGetImage("threeDimensional.png");
    }

    @Key(value="move-tool-contact-description.png")
    public static @Key(value="move-tool-contact-description.png") Icon moveToolContactDescription() {
        return IllustrationImageResource.tryGetImage("move-tool-contact-description.png");
    }

    @Key(value="stack.png")
    public static @Key(value="stack.png") Icon stack() {
        return IllustrationImageResource.tryGetImage("stack.png");
    }

    @Key(value="zeroDimensional.png")
    public static @Key(value="zeroDimensional.png") Icon zeroDimensional() {
        return IllustrationImageResource.tryGetImage("zeroDimensional.png");
    }

    @Key(value="smooth_transition_graph.png")
    public static @Key(value="smooth_transition_graph.png") Icon smoothTransitionGraph() {
        return IllustrationImageResource.tryGetImage("smooth_transition_graph.png");
    }

    @Key(value="grid1pos2d.png")
    public static @Key(value="grid1pos2d.png") Icon grid1pos2d() {
        return IllustrationImageResource.tryGetImage("grid1pos2d.png");
    }

    @Key(value="teach_plane_1.png")
    public static @Key(value="teach_plane_1.png") Icon teachPlane1() {
        return IllustrationImageResource.tryGetImage("teach_plane_1.png");
    }

    @Key(value="movecConstant.png")
    public static @Key(value="movecConstant.png") Icon movecConstant() {
        return IllustrationImageResource.tryGetImage("movecConstant.png");
    }

    @Key(value="teach_plane_all.png")
    public static @Key(value="teach_plane_all.png") Icon teachPlaneAll() {
        return IllustrationImageResource.tryGetImage("teach_plane_all.png");
    }

    @Key(value="tool_wrench.png")
    public static @Key(value="tool_wrench.png") Icon toolWrench() {
        return IllustrationImageResource.tryGetImage("tool_wrench.png");
    }

    @Key(value="movecNotConstant.png")
    public static @Key(value="movecNotConstant.png") Icon movecNotConstant() {
        return IllustrationImageResource.tryGetImage("movecNotConstant.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return IllustrationImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

