/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view;

import com.ur.disk.Directories;
import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.units.UnitType;
import com.ur.swing.units.Units;
import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;

@Deprecated
public class Settings {
    private static final String LANGUAGE = "language";
    private static final String ENGLISH_PROGRAMMING = "englishProgramming";
    private static final String REGION = "region";
    private static final String UNITS_KEY = "units";
    private static final String RUNNING_IN_DEVELOPMENT_MODE = "RunningInDevelopmentMode";
    private static final String SUPPRESS_BACKUP = "SuppressBackup";
    private static final String POLYSCOPE_MODIFICATIONS = "PolyscopeModifications";
    private static final String SETTINGS_FILENAME = "gui.properties";
    private static final String CONFIGURATION_AND_SETTINGS_PATH = Directories.urcontrol().getPath();
    private static final String LOAD_IMAGES_PATH = "loadImagesPath";
    public static final String REPORT_FOCUSABLE_TEXTFIELDS = "reportFocusableTextfields";
    private static String network = "eth1";
    private static NiceProperties properties;
    private static com.ur.polyscope.valueobjects.converters.UnitType units;
    private static LanguageConfiguration languageSettings;
    private static Collection<PolyScopeModification> polyscopeModifications;

    @Inject
    public Settings() {
    }

    public static void setNetworkInterface(String newNetwork) {
        Defense.notNullOrEmpty((String)network);
        network = newNetwork;
    }

    public static String getNetworkInterface() {
        return network;
    }

    static void forTestingSetProperties(Properties properties) {
        Settings.properties = properties == null ? null : new NiceProperties(properties);
    }

    public static String loadImagesPath() {
        return Settings.getProperties().getProperty(LOAD_IMAGES_PATH, Directories.home() + "/Pictures/");
    }

    public static LanguageConfiguration.SupportedLanguage getLanguage() {
        return Settings.getLanguageSettings().getLanguage();
    }

    public Locale getLanguageLocale() {
        return Settings.getLanguage().getLocale();
    }

    public Locale getLocaleForProgrammingLanguage() {
        if (Settings.isUsingEnglishProgramming()) {
            return LanguageConfiguration.SupportedLanguage.en.getLocale();
        }
        return this.getLanguageLocale();
    }

    public com.ur.polyscope.valueobjects.converters.UnitType getUnitType() {
        return Settings.getUnits();
    }

    public static boolean isUsingEnglishProgramming() {
        return Settings.getLanguageSettings().isUsingEnglishProgramming();
    }

    public static void setUseEnglishProgrammingForTest(boolean useEnglishProgrammingState) {
        Settings.getLanguageSettings().setUseEnglishProgramming(useEnglishProgrammingState);
        Settings.getProperties().setProperty(ENGLISH_PROGRAMMING, String.valueOf(useEnglishProgrammingState));
    }

    private static LanguageConfiguration getLanguageSettings() {
        if (languageSettings == null) {
            Settings.getProperties();
        }
        return languageSettings;
    }

    public static boolean isSuppressBackup() {
        return Settings.getProperties().getBoolean(SUPPRESS_BACKUP, false);
    }

    public static boolean isRunningInDevelopmentMode() {
        return Settings.getProperties().getBoolean(RUNNING_IN_DEVELOPMENT_MODE, false);
    }

    public static boolean hasPolyScopeModification(PolyScopeModification polyscopeModification) {
        if (polyscopeModifications == null) {
            Settings.getProperties();
        }
        return polyscopeModifications.contains((Object)polyscopeModification);
    }

    public static void setUnitsForTesting(com.ur.polyscope.valueobjects.converters.UnitType units) {
        Settings.getProperties().setProperty(UNITS_KEY, units.name());
        Settings.units = units;
        com.ur.polyscope.valueobjects.converters.Units.setUnitType((com.ur.polyscope.valueobjects.converters.UnitType)units);
        Units.setUnitType((UnitType)UnitType.getUnitType((String)units.toString()));
    }

    public static void setLanguageForTesting(LanguageConfiguration.SupportedLanguage language) {
        Settings.getProperties().setProperty(LANGUAGE, language.getLanguageName());
        Settings.getLanguageSettings().setLanguage(language);
    }

    public static com.ur.polyscope.valueobjects.converters.UnitType getUnits() {
        if (units == null) {
            Settings.getProperties();
        }
        return units;
    }

    public static NiceProperties getProperties() {
        if (properties == null) {
            properties = new NiceProperties(Settings.readPropertiesFile(SETTINGS_FILENAME));
            if (Settings.isRunningInDevelopmentMode()) {
                System.setProperty(RUNNING_IN_DEVELOPMENT_MODE, "true");
            }
            System.setProperty("urcontrol.home", Directories.urcontrol().getPath());
            Settings.loadLanguage();
            if (properties.containsKey(REGION)) {
                String regionStr = properties.getProperty(REGION, LanguageConfiguration.Region.GLOBAL.getName()).replace("_", "");
                languageSettings.setRegion(LanguageConfiguration.Region.getRegion((String)regionStr));
            }
            Settings.setForceZipFiles(properties.getBoolean("requestZippedFiles", true));
            Settings.setUnitsForTesting(com.ur.polyscope.valueobjects.converters.UnitType.getUnitType((String)properties.getProperty(UNITS_KEY, "")));
            System.setProperty(LOAD_IMAGES_PATH, properties.getProperty(LOAD_IMAGES_PATH, Directories.home() + "/Pictures/"));
            if ("true".equalsIgnoreCase(properties.getProperty(REPORT_FOCUSABLE_TEXTFIELDS, "false"))) {
                FeatureToggle.activateFeature((String)REPORT_FOCUSABLE_TEXTFIELDS);
            }
            Settings.loadPolyscopeModifications();
        }
        return properties;
    }

    private static void setForceZipFiles(boolean requestZippedFiles) {
        if (requestZippedFiles) {
            FeatureToggle.activateFeature((String)"requestZippedFiles");
        } else {
            FeatureToggle.deactivateFeature((String)"requestZippedFiles");
        }
    }

    private static void loadPolyscopeModifications() {
        String[] modificationsStrings;
        if (polyscopeModifications == null) {
            polyscopeModifications = EnumSet.noneOf(PolyScopeModification.class);
        } else {
            polyscopeModifications.clear();
        }
        String[] stringArray = modificationsStrings = Settings.getProperties().getStringArray(POLYSCOPE_MODIFICATIONS, new String[0]);
        int n = modificationsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            PolyScopeModification modification = PolyScopeModification.polyscopeModification(each);
            if (modification != PolyScopeModification.NONE) {
                polyscopeModifications.add(modification);
            }
            ++n2;
        }
    }

    private static void loadLanguage() {
        try {
            String language = Settings.getProperties().getProperty(LANGUAGE, null);
            LanguageConfiguration.SupportedLanguage supportedLanguage = LanguageConfiguration.SupportedLanguage.getLanguage((String)language);
            boolean isImplicitEnglishProgramming = supportedLanguage == LanguageConfiguration.SupportedLanguage.en || supportedLanguage == LanguageConfiguration.SupportedLanguage.us;
            boolean englishProgramming = Settings.getProperties().getBoolean(ENGLISH_PROGRAMMING, isImplicitEnglishProgramming);
            if (language == null && new File(String.valueOf(CONFIGURATION_AND_SETTINGS_PATH) + File.separator + LANGUAGE).exists()) {
                language = FileUtils.readFromFile((File)new File(String.valueOf(CONFIGURATION_AND_SETTINGS_PATH) + File.separator + LANGUAGE), null);
                englishProgramming = language.contains("pe");
            }
            if (StringUtils.isNullOrOnlyWhitespace((String)language)) {
                language = "";
            }
            languageSettings = new LanguageConfiguration(LanguageConfiguration.SupportedLanguage.getLanguage((String)language), LanguageConfiguration.Region.GLOBAL, englishProgramming);
        }
        catch (Exception exception) {
            languageSettings = new LanguageConfiguration();
            Log.warning((String)"Failed to load language file: Possibly corrupted or empty");
        }
    }

    private static Properties readPropertiesFile(String fileName) {
        String fileNameAndPath = String.valueOf(CONFIGURATION_AND_SETTINGS_PATH) + File.separator + fileName;
        try {
            return FileUtils.readPropertiesFromFile((String)fileNameAndPath);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ex) {
            Log.error((String)("Error while reading configuration file, '" + fileNameAndPath + "': "), (Throwable)ex);
        }
        return new Properties();
    }

    public static enum PolyScopeModification {
        NONE("NONE"),
        SEND_MODIFIED_JOINT_POSITION_LIMITS_FOR_WRIST3_TO_CONTROLLER("P1"),
        DISABLE_VALIDATION_OF_MODESELECTOR_WITHOUT_3POSITION_ENABLING_DEVICE("P2");

        private static final Map<String, PolyScopeModification> cache;
        private final String abbreviation;

        static {
            cache = new HashMap<String, PolyScopeModification>();
        }

        private PolyScopeModification(String abbriviation) {
            this.abbreviation = abbriviation;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public static PolyScopeModification polyscopeModification(String abbreviation) {
            if (cache.isEmpty()) {
                PolyScopeModification.buildCache();
            }
            if (cache.containsKey(abbreviation)) {
                return cache.get(abbreviation);
            }
            return NONE;
        }

        private static void buildCache() {
            PolyScopeModification[] polyScopeModificationArray = PolyScopeModification.values();
            int n = polyScopeModificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                PolyScopeModification each = polyScopeModificationArray[n2];
                cache.put(each.getAbbreviation(), each);
                ++n2;
            }
        }
    }
}

