/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.about;

import com.ur.i18n.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BaseView;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.swing.dialog.OkCancelDialogListener;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.view.DialogWithName;
import gui.tools.URDialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

@Singleton
@ExtensionPoint(value="AboutDialog")
public class ShowAboutDialogAction
extends AbstractActionDefinition
implements Menu {
    public static final String ABOUT_DIALOG_BUTTON = "ABOUT_DIALOG_BUTTON";
    private final TextResource textResource;
    private final MultiPaneMessagePanelFactory factory;
    private final URDialogCreator dialogCreator;
    private final List<MenuExtension.MenuContribution> menuContributionList = new ArrayList<MenuExtension.MenuContribution>();

    @Inject
    public ShowAboutDialogAction(TextResource textResource, MultiPaneMessagePanelFactory factory, URDialogCreator dialogCreator) {
        this.textResource = textResource;
        this.factory = factory;
        this.dialogCreator = dialogCreator;
        this.putValue("SmallIcon", ViewImageResource.aboutWhite());
        this.putValue("SelectedSmallIcon", ViewImageResource.aboutBlack());
        this.putValue("Name", textResource.About());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("InternalName", ABOUT_DIALOG_BUTTON);
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<MultiPaneMessagePanelFactory.Pane> panes = new ArrayList<MultiPaneMessagePanelFactory.Pane>();
        this.menuContributionList.sort(Comparator.comparingInt(MenuExtension.MenuContribution::getPriority));
        for (MenuExtension.MenuContribution menuContribution : this.menuContributionList) {
            panes.add(this.initializeMenuContribution(menuContribution, e));
        }
        InformationMessage message = new InformationMessage(DialogWithName.ABOUT.getName(), this.textResource.About(), "", this.textResource.Close());
        this.dialogCreator.showMultiPaneInformationDialog(this.factory, message, panes, this.createDialogListener());
    }

    private MultiPaneMessagePanelFactory.Pane initializeMenuContribution(MenuExtension.MenuContribution menuContribution, ActionEvent e) {
        Action contributionAction = menuContribution.contribution;
        contributionAction.actionPerformed(e);
        BaseView baseView = (BaseView)menuContribution.createComponent(contributionAction);
        String title = (String)contributionAction.getValue("Name");
        return this.createPane(title, baseView);
    }

    private OkCancelDialogListener createDialogListener() {
        return new OkCancelDialogListener(){

            public void onCancelClicked() {
            }

            public void onOkClicked() {
                this.onCancelClicked();
            }
        };
    }

    private MultiPaneMessagePanelFactory.Pane createPane(String title, BaseView infoPanel) {
        infoPanel.setVisible(true);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Dimension dimension = UIManager.getDimension("AboutPane.dimensions");
        wrapper.setPreferredSize(dimension);
        wrapper.add((Component)infoPanel, "Center");
        return new MultiPaneMessagePanelFactory.Pane(title, (JComponent)wrapper);
    }

    public void addMenuItem(MenuExtension.MenuContribution menuContribution) {
        this.menuContributionList.add(menuContribution);
    }
}

