/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.about;

import com.ur.swing.BaseView;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.util.logging.Log;
import com.ur.view.action.CopyrightPanel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class TechnicalInfoPanel
extends BaseView {
    private final ViewContext viewContext;
    private final Provider<CopyrightPanel> copyrightPanel;
    private final JLabel javaVersion = new JLabel();
    private final JLabel approxMemory = new JLabel();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Future<?> memoryUsageUpdateTask;

    @Inject
    public TechnicalInfoPanel(ViewContext viewContext, Provider<CopyrightPanel> copyrightPanelProvider) {
        this.viewContext = viewContext;
        this.copyrightPanel = copyrightPanelProvider;
        this.initComponents();
    }

    private void initComponents() {
        JPanel technicalPanel = this.buildJPanel();
        this.setContent(technicalPanel);
        this.setFooter((JComponent)this.copyrightPanel.get());
        this.addAncestorListener();
    }

    private JPanel buildJPanel() {
        return this.viewContext.createFormBuilder().label("JRE:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.javaVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label("Memory usage:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.approxMemory, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().getPanel();
    }

    private void addAncestorListener() {
        super.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                TechnicalInfoPanel.this.onVisible();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                TechnicalInfoPanel.this.onInvisible();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void onVisible() {
        this.javaVersion.setText(System.getProperty("java.version"));
        if (this.memoryUsageUpdateTask == null || this.memoryUsageUpdateTask.isDone()) {
            this.memoryUsageUpdateTask = this.executorService.submit(this.createUpdateRunnable());
        }
    }

    private void onInvisible() {
        if (this.memoryUsageUpdateTask != null) {
            this.memoryUsageUpdateTask.cancel(true);
        }
    }

    private Runnable createUpdateRunnable() {
        return () -> {
            TechnicalInfoPanel technicalInfoPanel = this;
            synchronized (technicalInfoPanel) {
                try {
                    while (true) {
                        this.updateMemory();
                        ((Object)((Object)this)).wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    Log.warning((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    private void updateMemory() {
        long memoryUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        SwingUtil.invokeLater(() -> this.approxMemory.setText(String.valueOf(memoryUsage / 1024L / 1024L) + " MiB / " + memoryUsage / 1000L / 1000L + " MB"));
    }
}

