/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.about;

import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.swing.BaseView;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.view.action.CopyrightPanel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VersionInfoPanel
extends BaseView {
    private final ViewContext viewContext;
    private final URVersionProvider urVersionProvider;
    private final Provider<CopyrightPanel> copyrightPanel;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected JLabel baselineVersion = new JLabel();
    protected JLabel polyscopeVersion = new JLabel();
    protected JLabel controllerVersion = new JLabel();
    protected JLabel firmwareVersion = new JLabel();
    protected JLabel platformVersion = new JLabel();
    private Future<?> versionUpdaterTask;

    @Inject
    public VersionInfoPanel(ViewContext viewContext, URVersionProvider urVersionProvider, Provider<CopyrightPanel> copyrightPanelProvider) {
        this.viewContext = viewContext;
        this.urVersionProvider = urVersionProvider;
        this.copyrightPanel = copyrightPanelProvider;
        this.initComponents();
    }

    private void initComponents() {
        JPanel versionPanel = this.viewContext.createFormBuilder().label("Baseline:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.baselineVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label("Polyscope:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.polyscopeVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label("Controller:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.controllerVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label("Firmware:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.firmwareVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label("Platform:", new FormBuilder.PanelConstraints[0]).component((JComponent)this.platformVersion, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().getPanel();
        this.setContent(versionPanel);
        this.setFooter((JComponent)this.copyrightPanel.get());
        this.update();
    }

    public void update() {
        if (this.versionUpdaterTask == null || this.versionUpdaterTask.isDone()) {
            this.versionUpdaterTask = this.executorService.submit(new VersionRunnable());
        }
    }

    private class VersionRunnable
    implements Runnable {
        private VersionRunnable() {
        }

        @Override
        public void run() {
            String baselineVersionString = this.getVersionString(VersionInfoPanel.this.urVersionProvider.getBaselineVersion());
            String polyscopeVersionString = this.getVersionString(VersionInfoPanel.this.urVersionProvider.getPolyscopeVersion());
            String controllerVersionString = this.getVersionString(VersionInfoPanel.this.urVersionProvider.getControllerVersion());
            String firmwareVersionString = this.getVersionString(VersionInfoPanel.this.urVersionProvider.getFirmwareVersion());
            String platformVersionString = this.getVersionString(VersionInfoPanel.this.urVersionProvider.getPlatformVersion());
            SwingUtil.invokeLater(() -> {
                VersionInfoPanel.this.baselineVersion.setText(baselineVersionString);
                VersionInfoPanel.this.polyscopeVersion.setText(polyscopeVersionString);
                VersionInfoPanel.this.controllerVersion.setText(controllerVersionString);
                VersionInfoPanel.this.firmwareVersion.setText(firmwareVersionString);
                VersionInfoPanel.this.platformVersion.setText(platformVersionString);
            });
        }

        private String getVersionString(URVersion version) {
            return version.toString();
        }
    }
}

