/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.action;

import com.ur.disk.Directories;
import com.ur.i18n.EulaResource;
import com.ur.i18n.TextResource;
import com.ur.swing.BaseView;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class LegalNoticePanel
extends BaseView {
    public static final String LEGAL_NOTICE_PANEL = "LEGAL_NOTICE_PANEL";
    public static final String LEGAL_NOTICE_COMBOBOX = "LEGAL_NOTICE.COMBOBOX";
    public static final String LEGAL_NOTICE_TEXTAREA = "LEGAL_NOTICE.TEXTAREA";
    private final TextResource textResource;
    private final EulaResource eulaResource;
    private final WidgetFactory widgetFactory;
    private JComboBox dropDown;
    private JTextPane textArea;
    private String pathToDirectory;
    private FlippablePanel contentPanel;
    private TextAreaCardPanel textareaCardPanel;

    @Inject
    public LegalNoticePanel(ViewContext viewContext) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.eulaResource = (EulaResource)viewContext.getTextResource(EulaResource.class);
        this.widgetFactory = viewContext.createWidgetFactory();
        this.pathToDirectory = String.valueOf(Directories.home().getAbsolutePath()) + "/legal_notices";
    }

    private static boolean makeDirIfNotExist(File path) {
        if (path.exists()) {
            return true;
        }
        if (path.mkdir()) {
            return true;
        }
        Log.debug((String)"The directory legal_notices does not exist");
        return false;
    }

    void setPathToLegalNoticesDirectory(String pathToDirectory) {
        this.pathToDirectory = pathToDirectory;
    }

    public LegalNoticePanel initComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 20));
        this.contentPanel = new FlippablePanel();
        this.textareaCardPanel = this.createTextArea();
        this.contentPanel.addCardPanel((CardPanel)this.textareaCardPanel);
        mainPanel.add((Component)this.contentPanel, "Center");
        mainPanel.add((Component)this.createTopPanel(), "First");
        this.setContent(mainPanel);
        this.setName(LEGAL_NOTICE_PANEL);
        return this;
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        JLabel legalLabel = this.widgetFactory.createLabel(this.textResource.legalNotice());
        topPanel.add(legalLabel);
        topPanel.add(Box.createGlue());
        JComboBox dropDownToDisplay = this.createComboBox();
        this.populateLegalNoticeComboBox(dropDownToDisplay);
        topPanel.add(dropDownToDisplay);
        return topPanel;
    }

    private JComboBox createComboBox() {
        this.dropDown = new JComboBox();
        this.dropDown.setMinimumSize(new Dimension(200, 14));
        this.dropDown.setMaximumSize(new Dimension(400, 20));
        this.dropDown.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (value instanceof File) {
                return new JLabel(((File)value).getName().replace('_', ' '));
            }
            if (value == null) {
                return new JLabel();
            }
            return new JLabel(value.toString());
        });
        this.dropDown.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegalNoticePanel.this.updateToSelection();
            }
        });
        this.dropDown.setName(LEGAL_NOTICE_COMBOBOX);
        return this.dropDown;
    }

    private void populateLegalNoticeComboBox(JComboBox jComboBox) {
        File[] files = this.getFilesToDisplay();
        this.populateEmptyLegalNoticeListWithEULA(jComboBox);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!"empty".equals(file.getName())) {
                jComboBox.addItem(file);
                this.selectEulaFile(jComboBox, file);
            }
            ++n2;
        }
    }

    private void populateEmptyLegalNoticeListWithEULA(JComboBox jComboBox) {
        File file = new File("EULA");
        jComboBox.addItem(file);
        this.selectEulaFile(jComboBox, file);
    }

    private File[] getFilesToDisplay() {
        File legalNotices = new File(this.pathToDirectory);
        if (!LegalNoticePanel.makeDirIfNotExist(legalNotices)) {
            return new File[0];
        }
        File[] files = legalNotices.listFiles();
        if (files == null) {
            Log.debug((String)"Could not list files in the directory legal_notices");
            return new File[0];
        }
        return files;
    }

    private void selectEulaFile(JComboBox jComboBox, File file) {
        if (this.isEula(file)) {
            jComboBox.setSelectedItem(file);
            this.updateToSelection();
        }
    }

    private TextAreaCardPanel createTextArea() {
        this.textArea = new JTextPane();
        this.textArea.setEditable(false);
        this.textArea.setFont(this.textArea.getFont().deriveFont(12.0f));
        this.textArea.setName(LEGAL_NOTICE_TEXTAREA);
        return new TextAreaCardPanel(new JScrollPane(this.textArea)).initComponents();
    }

    private void updateToSelection() {
        File file = (File)this.dropDown.getSelectedItem();
        this.contentPanel.switchTo(TextAreaCardPanel.class, (Object)this.textareaCardPanel);
        if (this.isEula(file)) {
            this.textArea.setContentType("text/html");
            this.textArea.setText(this.eulaResource.EULA());
        } else {
            String content = FileUtils.readFromFile((File)file, (String)"");
            this.textArea.setContentType("text/plain");
            this.textArea.setText(content);
        }
    }

    private boolean isEula(File file) {
        return "eula".equalsIgnoreCase(file.getName());
    }

    protected String getContentType() {
        return this.textArea.getContentType();
    }

    private static class TextAreaCardPanel
    extends CardPanel {
        private final JScrollPane content;

        TextAreaCardPanel(JScrollPane content) {
            this.content = content;
        }

        TextAreaCardPanel initComponents() {
            this.setLayout(new GridLayout(1, 1));
            this.add(this.content);
            return this;
        }
    }
}

