/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.action;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.resources.ViewImageResource;
import com.ur.reversible.Reversible;
import com.ur.swing.ActionDefinition;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.action.AbstractUndoRedoProgramAction;
import com.ur.view.action.RedoProgramActionProgramEventListener;
import gui.program.ProgramRootNode;
import gui.program.ProgramUndoRedoService;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.inject.Inject;

public class RedoProgramAction
extends AbstractUndoRedoProgramAction {
    public static final String REDO_PROGRAM_ACTION = "redoAction." + RedoProgramAction.class.getSimpleName();
    private final transient ProgramUndoRedoService undoRedoService;

    @Inject
    RedoProgramAction(ProgramUndoRedoService undoRedoService, EventManager eventManager) {
        this.undoRedoService = undoRedoService;
        this.putValue("SmallIcon", ViewImageResource.redoIcon());
        this.putValue("InternalName", REDO_PROGRAM_ACTION);
        this.putValue("Function", ActionDefinition.Function.TOOLBAR);
        this.putValue("HelpId", "gui:program_undo_redo");
        this.setEnabled(false);
        undoRedoService.addListener((action, reversible) -> this.setEnabled(undoRedoService.canRedo()));
        RedoProgramActionProgramEventListener listener = new RedoProgramActionProgramEventListener(this, this.undoRedoService);
        eventManager.addWeakListener((Object)this, ProgramEventListener.class, (Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        ProgramUndoRedoService programUndoRedoService = this.undoRedoService;
        synchronized (programUndoRedoService) {
            if (!this.undoRedoService.canRedo()) {
                Log.info((String)"Redo Request: ignored");
                return;
            }
            Reversible r = this.undoRedoService.redo();
            Optional<AbstractProgramNode> node = Optional.ofNullable(this.getTargetNode((Reversible<AbstractProgramNode>)r));
            node.ifPresent(this::selectSuitableNode);
        }
    }

    private void selectSuitableNode(AbstractProgramNode targetNode) {
        if (targetNode.getParent() != null) {
            targetNode.setSelected();
        } else if (targetNode instanceof ProgramRootNode) {
            ((ProgramRootNode)targetNode).getMainProgram().setSelected();
        }
    }
}

