/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.action;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.dialog.ErrorMessage;
import gui.tools.DialogCreator;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

public class SuppressNodeAction
extends AbstractActionDefinition {
    private final EditProgramService editProgramService;
    private final DialogCreator dialogCreator;
    private TextResource textResource;

    @Inject
    public SuppressNodeAction(EditProgramService editProgramService, DialogCreator dialogCreator, TextResource textResource) {
        this.editProgramService = editProgramService;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.putValue("SmallIcon", ViewImageResource.suppress());
        this.putValue("Function", ActionDefinition.Function.TOOLBAR);
        this.putValue("HelpId", "gui:program_suppress");
    }

    public void actionPerformed(ActionEvent e) {
        this.suppressNode(this.editProgramService.getSelected());
    }

    public void suppressNode(AbstractProgramNode currentNode) {
        if (currentNode.isSuppressible()) {
            this.editProgramService.suppressNode(currentNode);
        } else {
            this.dialogCreator.showErrorDialog(new ErrorMessage(this.textResource.Suppress(), this.textResource.CannotSuppressNode()), null);
        }
    }
}

