/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.action;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.resources.ViewImageResource;
import com.ur.reversible.Reversible;
import com.ur.swing.ActionDefinition;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.action.AbstractUndoRedoProgramAction;
import com.ur.view.action.UndoProgramActionProgramEventListener;
import gui.program.ProgramRootNode;
import gui.program.ProgramUndoRedoService;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class UndoProgramAction
extends AbstractUndoRedoProgramAction {
    public static final String UNDO_PROGRAM_ACTION = "undoAction." + UndoProgramAction.class.getSimpleName();
    private final transient ProgramUndoRedoService undoRedoService;
    private final AtomicBoolean blockConsecutiveRequests = new AtomicBoolean(false);

    @Inject
    public UndoProgramAction(ProgramUndoRedoService undoRedoService, EventManager eventManager) {
        this.undoRedoService = undoRedoService;
        this.resolveValues();
        this.setEnabled(false);
        undoRedoService.addListener((action, reversible) -> this.setEnabled(undoRedoService.canUndo()));
        UndoProgramActionProgramEventListener listener = new UndoProgramActionProgramEventListener(this, this.undoRedoService);
        eventManager.addWeakListener((Object)this, ProgramEventListener.class, (Object)listener);
    }

    private void resolveValues() {
        this.putValue("SmallIcon", ViewImageResource.undoIcon());
        this.putValue("InternalName", UNDO_PROGRAM_ACTION);
        this.putValue("Function", ActionDefinition.Function.TOOLBAR);
        this.putValue("HelpId", "gui:program_undo_redo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        ProgramUndoRedoService programUndoRedoService = this.undoRedoService;
        synchronized (programUndoRedoService) {
            if (this.isRequestIgnored()) {
                return;
            }
            this.guardedAction();
        }
    }

    private boolean isRequestIgnored() {
        if (this.blockConsecutiveRequests.get() || !this.undoRedoService.canUndo()) {
            Log.info((String)"Undo Request: ignored");
            return true;
        }
        return false;
    }

    private void guardedAction() {
        this.blockConsecutiveRequests.set(true);
        this.undoAction();
        this.blockConsecutiveRequests.set(false);
    }

    private void undoAction() {
        Reversible reversible = this.undoRedoService.undo();
        this.updateActiveSelection((Reversible<AbstractProgramNode>)reversible);
    }

    private void updateActiveSelection(Reversible<AbstractProgramNode> reversible) {
        Optional<AbstractProgramNode> optionalNode = Optional.ofNullable(this.getTargetNode(reversible));
        optionalNode.ifPresent(this::selectSuitableNode);
    }

    private void selectSuitableNode(AbstractProgramNode targetNode) {
        Optional<AbstractProgramNode> suitableNode = this.getSuitableNode(targetNode);
        suitableNode.ifPresent(AbstractProgramNode::setSelected);
    }

    private Optional<AbstractProgramNode> getSuitableNode(AbstractProgramNode targetNode) {
        if (targetNode.getParent() != null) {
            return Optional.of(targetNode);
        }
        if (targetNode instanceof ProgramRootNode) {
            return Optional.ofNullable(((ProgramRootNode)targetNode).getMainProgram());
        }
        return Optional.ofNullable(targetNode.getProgramRoot());
    }
}

