/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.controllerinterface;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.util.event.EventManager;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;
import javax.inject.Inject;

public class RobotMessageConnectionListener
implements ControllerConnectionListener {
    private final RobotMessageProducer producer;
    private final TextResource textResource;

    @Inject
    RobotMessageConnectionListener(RobotMessageProducer producer, TextResource textResource, EventManager eventManager) {
        this.producer = producer;
        this.textResource = textResource;
        eventManager.addStrongListener(ControllerConnectionListener.class, (Object)this);
    }

    public void connectedToController() {
        this.producer.generateAndNotify(this.textResource.connectedToController());
    }

    public void disconnectedFromController() {
        this.sendGuiMessage(this.textResource.disconnectedFromController(), RobotState.getLatestRobotState().timestamp);
    }

    public void failedToSendMessage(String message) {
        this.producer.generateAndNotify(this.textResource.failedToActivateRealRobot());
    }

    private void sendGuiMessage(String title, long timestamp) {
        RobotMessage robotMessage = new RobotMessage();
        robotMessage.title = title;
        robotMessage.type = RobotMessageType.KEY;
        robotMessage.timestamp = timestamp;
        robotMessage.source = MessageSource.GUI;
        robotMessage.notifyAllSubscribers();
    }
}

